/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.uniprot.EbiFastaDownloader;
import org.sing_group.seda.blast.uniprot.UniProtBlastHit;
import org.sing_group.seda.blast.uniprot.UniProtBlastHits;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.Hit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;

public class UniProtBlastTransformation
implements SequencesGroupDatasetTransformation {
    public static final DatabaseOption DEFAULT_DATABASE = DatabaseOption.UNIPROTKB;
    public static final OutputTypeParameter DEFAULT_OUTPUT_TYPE_PARAMETER = OutputTypeParameter.ALIGNED;
    public static final ExpectationOption DEFAULT_EXPECTATION_OPTION = ExpectationOption.TEN;
    public static final MatrixOption DEFAULT_MATRIX_OPTION = MatrixOption.BLOSUM_62;
    public static final FilterOption DEFAULT_FILTER_OPTION = FilterOption.YES;
    public static final AlignmentCutoffOption DEFAULT_ALIGNMENT_CUTOFF = AlignmentCutoffOption.TWO_HUNDRED_FIFTY;
    private static final String CONCURRENT_BLAST_MESSAGE = "It seems that an UniProt BLAST operation is already running. SEDA only allows to execute one UniProt BLAST operation at a time in order respect EMBL-EBI policies regarding the usage of resources and avoid problems.";
    private File lockFile;
    private DatatypeFactory factory;
    private DatabaseOption database;
    private OutputTypeParameter outputType;
    private ExpectationOption expectValue;
    private MatrixOption matrix;
    private FilterOption filterOption;
    private boolean gapped;
    private AlignmentCutoffOption hits;

    public UniProtBlastTransformation(DatabaseOption database, OutputTypeParameter outputType, ExpectationOption expectValue, MatrixOption matrix, FilterOption filterOption, boolean gapped, AlignmentCutoffOption hits, DatatypeFactory factory) {
        this.database = database;
        this.outputType = outputType;
        this.expectValue = expectValue;
        this.matrix = matrix;
        this.filterOption = filterOption;
        this.gapped = gapped;
        this.hits = hits;
        this.factory = factory;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        Sequence sequence = this.getSequence(dataset);
        this.createLockFile();
        UniProtBlastHits blastHits = this.getUniProtBlastHits(sequence);
        if (blastHits.isEmpty()) {
            this.lockFile.delete();
            throw new TransformationException("No hits found");
        }
        SequencesGroup result = this.getSequencesGroupResult(sequence, blastHits);
        return this.factory.newSequencesGroupDataset(result);
    }

    private void createLockFile() {
        this.lockFile = new File(System.getProperty("user.home"), ".seda-uniprot.lock");
        if (this.lockFile.exists()) {
            throw new TransformationException(CONCURRENT_BLAST_MESSAGE);
        }
        try {
            this.lockFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TransformationException("Could not create lock file");
        }
    }

    private Sequence getSequence(SequencesGroupDataset dataset) {
        if (dataset.getSequencesGroupsCount() > 1 || dataset.getSequencesGroups().findFirst().get().getSequenceCount() > 1) {
            throw new IllegalArgumentException("The UniProt BLAST operation only accepts 1 FASTA file containing exactly 1 sequence");
        }
        return dataset.getSequencesGroups().findFirst().get().getSequence(0);
    }

    private UniProtBlastHits getUniProtBlastHits(Sequence sequence) {
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniProtBlastHits blastHits = new UniProtBlastHits();
        if (this.database.equals((Object)DatabaseOption.UNIPARC)) {
            UniParcBlastService blastService = serviceFactoryInstance.getUniParcBlastService();
            blastService.start();
            CompletableFuture resultFuture = blastService.runBlast(this.getBlastInput(sequence.getChain()));
            try {
                BlastResult blastResult = (BlastResult)resultFuture.get();
                blastHits = UniProtBlastTransformation.getUniProtBlastHits(UniProtBlastTransformation.asStream(blastResult.hits().iterator(), false).map(Hit::getSummary).collect(Collectors.toList()));
            }
            catch (InterruptedException | ExecutionException e) {
                this.lockFile.delete();
                throw new TransformationException(e);
            }
            finally {
                blastService.stop();
            }
        }
        if (this.database.getDisplayName().toUpperCase().contains("UNIREF")) {
            UniRefBlastService blastService = serviceFactoryInstance.getUniRefBlastService();
            blastService.start();
            CompletableFuture resultFuture = blastService.runBlast(this.getBlastInput(sequence.getChain()));
            try {
                BlastResult blastResult = (BlastResult)resultFuture.get();
                blastHits = UniProtBlastTransformation.getUniProtBlastHits(UniProtBlastTransformation.asStream(blastResult.hits().iterator(), false).map(Hit::getSummary).collect(Collectors.toList()));
            }
            catch (InterruptedException | ExecutionException e) {
                this.lockFile.delete();
                throw new TransformationException(e);
            }
            finally {
                blastService.stop();
            }
        }
        UniProtBlastService blastService = serviceFactoryInstance.getUniProtBlastService();
        blastService.start();
        CompletableFuture resultFuture = blastService.runBlast(this.getBlastInput(sequence.getChain()));
        try {
            BlastResult blastResult = (BlastResult)resultFuture.get();
            blastHits = UniProtBlastTransformation.getUniProtBlastHits(UniProtBlastTransformation.asStream(blastResult.hits().iterator(), false).map(UniProtHit::getSummary).collect(Collectors.toList()));
        }
        catch (InterruptedException | ExecutionException e) {
            this.lockFile.delete();
            throw new TransformationException(e);
        }
        finally {
            blastService.stop();
        }
        return blastHits;
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator, boolean parallel) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    private static UniProtBlastHits getUniProtBlastHits(List<BlastSummary> summaries) {
        UniProtBlastHits blastHits = new UniProtBlastHits();
        for (BlastSummary summary : summaries) {
            LinkedList<String> alignmments = new LinkedList<String>();
            summary.getAlignments().forEach(a -> alignmments.add(a.getMatchSeq()));
            blastHits.add(new UniProtBlastHit(summary.getEntryId(), summary.getDescription(), alignmments));
        }
        return blastHits;
    }

    private BlastInput getBlastInput(String sequence) {
        return new BlastInput.Builder(this.database, sequence).withMaximumNumberOfAlignments(this.hits).withGapAlign(this.gapped).withExpectation(this.expectValue).withFilter(this.filterOption).withMatrix(this.matrix).build();
    }

    private SequencesGroup getSequencesGroupResult(Sequence sequence, UniProtBlastHits blastHits) {
        if (this.outputType.equals((Object)OutputTypeParameter.ALIGNED)) {
            LinkedList<Sequence> alignedSequences = new LinkedList<Sequence>();
            for (UniProtBlastHit h : blastHits) {
                if (h.getAlignments().size() == 1) {
                    alignedSequences.add(this.factory.newSequence(h.getEntryId(), h.getDescription(), h.getAlignments().get(0).replace("-", ""), Collections.emptyMap()));
                    continue;
                }
                for (int i = 0; i < h.getAlignments().size(); ++i) {
                    alignedSequences.add(this.factory.newSequence(h.getEntryId() + "_" + (i + 1), h.getDescription(), h.getAlignments().get(i).replace("-", ""), Collections.emptyMap()));
                }
            }
            this.lockFile.delete();
            return this.factory.newSequencesGroup(sequence.getName() + "_aligned_sequences.fasta", Collections.emptyMap(), alignedSequences);
        }
        try {
            Path outputFasta = Files.createTempFile("seda-uniprot-blast", "fasta", new FileAttribute[0]);
            EbiFastaDownloader.downloadFasta(outputFasta.toFile(), blastHits.stream().map(UniProtBlastHit::getEntryId).collect(Collectors.toList()));
            SequencesGroup outputSequencesGroup = this.factory.newSequencesGroup(outputFasta);
            SequencesGroup sequencesGroup = this.factory.newSequencesGroup(sequence.getName() + "_complete_sequences.fasta", Collections.emptyMap(), outputSequencesGroup.getSequences().collect(Collectors.toList()));
            return sequencesGroup;
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
        finally {
            this.lockFile.delete();
        }
    }
}

