/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.client.ClientProtocolException;
import org.sing_group.seda.blast.datatype.SequenceType;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastHit;
import org.sing_group.seda.blast.ncbi.NcbiBlastHits;
import org.sing_group.seda.blast.ncbi.NcbiBlastRequest;
import org.sing_group.seda.blast.ncbi.NcbiBlastRequestStatus;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.NcbiEutils;
import org.sing_group.seda.blast.ncbi.parameters.NcbiBlastParameter;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class NcbiBlastTransformation
implements SequencesGroupDatasetTransformation {
    public static final OutputTypeParameter DEFAULT_OUTPUT_TYPE_PARAMETER = OutputTypeParameter.ALIGNED;
    private static final String CONCURRENT_NCBI_BLAST_MESSAGE = "It seems that an NCBI BLAST operation is already running. SEDA only allows to execute one NCBI BLAST operation at a time in order respect NCBI policies regarding the usage of resources and avoid problems.";
    private NcbiBlastType blastType;
    private NcbiBlastDatabase blastDatabase;
    private OutputTypeParameter outputType;
    private List<NcbiBlastParameter> blastParameters;
    private DatatypeFactory factory;
    private File lockFile;

    public NcbiBlastTransformation(NcbiBlastType blastType, NcbiBlastDatabase blastDatabase, OutputTypeParameter outputType, List<NcbiBlastParameter> blastParameters, DatatypeFactory factory) {
        this.blastType = blastType;
        this.blastDatabase = blastDatabase;
        this.outputType = outputType;
        this.blastParameters = blastParameters;
        this.factory = factory;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        Sequence sequence = this.getSequence(dataset);
        this.createLockFile();
        NcbiBlastRequest request = new NcbiBlastRequest(this.blastType, this.blastDatabase, sequence.getChain(), this.blastParameters);
        try {
            request.query();
        }
        catch (IOException | URISyntaxException e) {
            this.lockFile.delete();
            throw new TransformationException(e);
        }
        Optional<String> requestId = request.getRequestId();
        if (requestId.isPresent()) {
            try {
                int nTry = 1;
                NcbiBlastRequestStatus status = request.getStatus();
                while (status == NcbiBlastRequestStatus.WAITING) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(nTry++ * 15));
                    status = request.getStatus();
                }
                if (status.equals((Object)NcbiBlastRequestStatus.READY_WITH_HITS)) {
                    NcbiBlastHits blastHits = request.getBlastHits();
                    SequencesGroupDataset sequencesGroupDataset = this.factory.newSequencesGroupDataset(this.getSequencesGroupResult(sequence, blastHits));
                    return sequencesGroupDataset;
                }
                try {
                    throw new TransformationException("No hits found for request ID: " + requestId.get());
                }
                catch (IOException | InterruptedException | URISyntaxException e) {
                    throw new TransformationException(e);
                }
            }
            finally {
                this.lockFile.delete();
            }
        }
        this.lockFile.delete();
        throw new TransformationException("The query failed on submission");
    }

    private void createLockFile() {
        this.lockFile = new File(System.getProperty("user.home"), ".seda-ncbi.lock");
        if (this.lockFile.exists()) {
            throw new TransformationException(CONCURRENT_NCBI_BLAST_MESSAGE);
        }
        try {
            this.lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new TransformationException("Could not create lock file", e);
        }
    }

    private Sequence getSequence(SequencesGroupDataset dataset) {
        if (dataset.getSequencesGroupsCount() > 1 || dataset.getSequencesGroups().findFirst().get().getSequenceCount() > 1) {
            throw new IllegalArgumentException("The NCBI blast operation only accepts 1 FASTA file containing exactly 1 sequence");
        }
        return dataset.getSequencesGroups().findFirst().get().getSequence(0);
    }

    private SequencesGroup getSequencesGroupResult(Sequence sequence, NcbiBlastHits blastHits) throws ClientProtocolException, URISyntaxException, IOException {
        if (this.outputType.equals((Object)OutputTypeParameter.ALIGNED)) {
            LinkedList<Sequence> alignedSequences = new LinkedList<Sequence>();
            for (NcbiBlastHit h : blastHits) {
                if (h.getHspHseqs().size() == 1) {
                    alignedSequences.add(this.factory.newSequence(h.getAccession(), h.getDescription(), h.getHspHseqs().get(0).replace("-", ""), Collections.emptyMap()));
                    continue;
                }
                for (int i = 0; i < h.getHspHseqs().size(); ++i) {
                    alignedSequences.add(this.factory.newSequence(h.getAccession() + "_" + (i + 1), h.getDescription(), h.getHspHseqs().get(i).replace("-", ""), Collections.emptyMap()));
                }
            }
            return this.factory.newSequencesGroup(sequence.getName() + "_aligned_sequences.fasta", Collections.emptyMap(), alignedSequences);
        }
        Path outputFasta = Files.createTempFile("seda-ncbi-blast", "fasta", new FileAttribute[0]);
        String database = this.blastType.getDatabaseType().equals((Object)SequenceType.NUCLEOTIDES) ? "nuccore" : "protein";
        NcbiEutils.downloadFasta(outputFasta.toFile(), blastHits.stream().map(NcbiBlastHit::getAccession).collect(Collectors.toList()), database);
        SequencesGroup outputSequencesGroup = this.factory.newSequencesGroup(outputFasta);
        return this.factory.newSequencesGroup(sequence.getName() + "_complete_sequences.fasta", Collections.emptyMap(), outputSequencesGroup.getSequences().collect(Collectors.toList()));
    }
}

