/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DefaultBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DockerBlastBinariesExecutor;
import org.sing_group.seda.blast.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.blast.gui.SystemBinaryExecutionConfigurationPanel;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class BlastExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel blastExecutableCardsPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private BinaryConfigurationPanelListener<BlastBinariesExecutor> blastExecutorChanged;

    public BlastExecutionConfigurationPanel(BinaryConfigurationPanelListener<BlastBinariesExecutor> binaryConfigurationPanelListener) {
        this.blastExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.blastExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.blastExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.blast", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.blastExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.blastExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::blastBinaryExecutorCardChanged);
        this.add((Component)this.blastExecutableCardsPanel);
    }

    private void blastBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.blastExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<BlastBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<BlastBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.blastExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(BlastBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerBlastBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerBlastBinariesExecutor)binariesExecutor).getDockerImage());
            this.blastExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultBlastBinariesExecutor) {
            File directory = ((DefaultBlastBinariesExecutor)binariesExecutor).getBlastDirectory();
            if (directory != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(directory);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.blastExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown BlastBinariesExecutor implementation");
        }
    }
}

