/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Aliases {
    public static final Aliases EMPTY = new Aliases(Collections.emptyMap(), Collections.emptyMap(), 0);
    private static final String COLLECTION = "collection";
    private static final String COLLECTION_METADATA = "collection_metadata";
    private final Map<String, List<String>> collectionAliases;
    private final Map<String, Map<String, String>> collectionAliasMetadata;
    private final int zNodeVersion;

    private Aliases(Map<String, List<String>> collectionAliases, Map<String, Map<String, String>> collectionAliasMetadata, int zNodeVersion) {
        this.collectionAliases = Objects.requireNonNull(collectionAliases);
        this.collectionAliasMetadata = Objects.requireNonNull(collectionAliasMetadata);
        this.zNodeVersion = zNodeVersion;
    }

    public static Aliases fromJSON(byte[] bytes, int zNodeVersion) {
        Map aliasMap = bytes == null || bytes.length == 0 ? Collections.emptyMap() : (Map)Utils.fromJSON(bytes);
        Map<String, Object> colAliases = aliasMap.getOrDefault(COLLECTION, Collections.emptyMap());
        colAliases = Aliases.convertMapOfCommaDelimitedToMapOfList(colAliases);
        Map<String, Map<String, String>> colMeta = aliasMap.getOrDefault(COLLECTION_METADATA, Collections.emptyMap());
        colMeta.replaceAll((k, metaMap) -> Collections.unmodifiableMap(metaMap));
        return new Aliases(colAliases, colMeta, zNodeVersion);
    }

    public byte[] toJSON() {
        if (this.collectionAliases.isEmpty()) {
            assert (this.collectionAliasMetadata.isEmpty());
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> tmp = new LinkedHashMap<String, Map<String, Object>>();
        tmp.put(COLLECTION, Aliases.convertMapOfListToMapOfCommaDelimited(this.collectionAliases));
        if (!this.collectionAliasMetadata.isEmpty()) {
            tmp.put(COLLECTION_METADATA, this.collectionAliasMetadata);
        }
        return Utils.toJSON(tmp);
    }

    public static Map<String, List<String>> convertMapOfCommaDelimitedToMapOfList(Map<String, String> collectionAliasMap) {
        return collectionAliasMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Aliases.splitCollections((String)e.getValue()), (a, b) -> {
            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate key %s", b));
        }, LinkedHashMap::new));
    }

    private static List<String> splitCollections(String collections) {
        return Collections.unmodifiableList(StrUtils.splitSmart(collections, ",", true));
    }

    public static Map<String, String> convertMapOfListToMapOfCommaDelimited(Map<String, List<String>> collectionAliasMap) {
        return collectionAliasMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (Iterable)e.getValue()), (a, b) -> {
            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate key %s", b));
        }, LinkedHashMap::new));
    }

    public int getZNodeVersion() {
        return this.zNodeVersion;
    }

    public Map<String, String> getCollectionAliasMap() {
        return Collections.unmodifiableMap(Aliases.convertMapOfListToMapOfCommaDelimited(this.collectionAliases));
    }

    public Map<String, List<String>> getCollectionAliasListMap() {
        return Collections.unmodifiableMap(this.collectionAliases);
    }

    public Map<String, String> getCollectionAliasMetadata(String alias) {
        return this.collectionAliasMetadata.getOrDefault(alias, Collections.emptyMap());
    }

    public List<String> resolveAliases(String aliasName) {
        return Aliases.resolveAliasesGivenAliasMap(this.collectionAliases, aliasName);
    }

    public static List<String> resolveAliasesGivenAliasMap(Map<String, List<String>> collectionAliasListMap, String aliasName) {
        List<String> level1 = collectionAliasListMap.get(aliasName);
        if (level1 == null) {
            return Collections.singletonList(aliasName);
        }
        ArrayList<String> result = new ArrayList<String>(level1.size());
        for (String level1Alias : level1) {
            List<String> level2 = collectionAliasListMap.get(level1Alias);
            if (level2 == null) {
                result.add(level1Alias);
                continue;
            }
            result.addAll(level2);
        }
        return Collections.unmodifiableList(result);
    }

    public Aliases cloneWithCollectionAlias(String alias, String collections) {
        Map<String, Map<String, String>> newColMetadata;
        if (alias == null) {
            throw new NullPointerException("Alias name cannot be null");
        }
        LinkedHashMap<String, List<String>> newColAliases = new LinkedHashMap<String, List<String>>(this.collectionAliases);
        if (collections == null) {
            newColMetadata = new LinkedHashMap<String, Map<String, String>>(this.collectionAliasMetadata);
            newColMetadata.remove(alias);
            newColAliases.remove(alias);
        } else {
            newColMetadata = this.collectionAliasMetadata;
            newColAliases.put(alias, Aliases.splitCollections(collections));
        }
        return new Aliases(newColAliases, newColMetadata, this.zNodeVersion);
    }

    public Aliases cloneWithCollectionAliasMetadata(String alias, String metadataKey, String metadataValue) {
        if (!this.collectionAliases.containsKey(alias)) {
            throw new IllegalArgumentException(alias + " is not a valid alias");
        }
        if (metadataKey == null) {
            throw new IllegalArgumentException("Null is not a valid metadata key");
        }
        LinkedHashMap<String, Map<String, String>> newColMetadata = new LinkedHashMap<String, Map<String, String>>(this.collectionAliasMetadata);
        LinkedHashMap<String, String> newMetaMap = new LinkedHashMap<String, String>(newColMetadata.getOrDefault(alias, Collections.emptyMap()));
        if (metadataValue != null) {
            newMetaMap.put(metadataKey, metadataValue);
        } else {
            newMetaMap.remove(metadataKey);
        }
        newColMetadata.put(alias, Collections.unmodifiableMap(newMetaMap));
        return new Aliases(this.collectionAliases, newColMetadata, this.zNodeVersion);
    }

    public String toString() {
        return "Aliases{collectionAliases=" + this.collectionAliases + ", collectionAliasMetadata=" + this.collectionAliasMetadata + ", zNodeVersion=" + this.zNodeVersion + '}';
    }
}

