/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.tool;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class EntryBufferedReader {
    private long entryStartPosition = 0L;
    private long entryEndPosition = 0L;
    private long bufferStartPosition = 0L;
    private final FileChannel channel;
    private final byte[] entryEnding = "//\n".getBytes();
    private ByteBuffer buffer;
    private boolean getFromFile = true;
    private final int size = 2136997888;
    private long timeUserdInAllocateBuffer = 0L;
    private long totalTimeUsedScanning = 0L;

    public EntryBufferedReader(String fileName) throws FileNotFoundException {
        RandomAccessFile channel1 = new RandomAccessFile(fileName, "r");
        this.channel = channel1.getChannel();
    }

    public long getTimeUserdInAllocateBuffer() {
        return this.timeUserdInAllocateBuffer / 1000000000L;
    }

    public long getTotalTimeUsedScanning() {
        return this.totalTimeUsedScanning / 1000000000L;
    }

    private boolean reNewBuffer() throws IOException {
        if (this.entryEndPosition >= this.channel.size()) {
            return false;
        }
        long currentTime = System.nanoTime();
        this.bufferStartPosition = this.entryEndPosition;
        this.entryStartPosition = this.entryEndPosition;
        long remainingLength = this.channel.size() - this.bufferStartPosition;
        int buffersize = (int)(remainingLength >= 2136997888L ? 2136997888L : remainingLength);
        if (this.buffer != null) {
            this.buffer = null;
            System.gc();
        }
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferStartPosition, buffersize);
        this.getFromFile = false;
        this.timeUserdInAllocateBuffer += System.nanoTime() - currentTime;
        return true;
    }

    public void reset() {
        this.entryStartPosition = 0L;
        this.entryEndPosition = 0L;
        this.bufferStartPosition = 0L;
        this.getFromFile = true;
        this.timeUserdInAllocateBuffer = 0L;
        this.totalTimeUsedScanning = 0L;
    }

    private boolean seekingEntryEndInBuffer(ByteBuffer buffer) {
        block0: while (buffer.remaining() >= this.entryEnding.length) {
            for (int j = 0; j < this.entryEnding.length; ++j) {
                byte b = buffer.get();
                if (b != this.entryEnding[j]) continue block0;
            }
            this.entryEndPosition = (long)buffer.position() + this.bufferStartPosition;
            return true;
        }
        return false;
    }

    public String next() throws IOException {
        boolean b;
        long currentTime = System.nanoTime();
        if (this.getFromFile && !(b = this.reNewBuffer())) {
            return null;
        }
        b = this.seekingEntryEndInBuffer(this.buffer);
        if (!b) {
            boolean b2 = this.reNewBuffer();
            if (!b2) {
                return null;
            }
            boolean b1 = this.seekingEntryEndInBuffer(this.buffer);
            Preconditions.checkState((boolean)b1, (Object)"if exception happened here, the size is setting incorrectly");
        }
        byte[] bytes = new byte[(int)(this.entryEndPosition - this.entryStartPosition)];
        this.buffer.position((int)(this.entryStartPosition - this.bufferStartPosition));
        this.buffer.get(bytes);
        this.entryStartPosition = this.entryEndPosition;
        this.totalTimeUsedScanning += System.nanoTime() - currentTime;
        return new String(bytes);
    }
}

