/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.os;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class OrganismLineParserHelper {
    private static final List<String> STRAINS = Arrays.asList(" (strain", " (isolate");

    public static Organism parse(String organismName) {
        String value = organismName;
        Organism organism = DefaultUniProtFactory.getInstance().buildOrganism();
        if (value.endsWith(".") && value.charAt(value.length() - 2) != ')' || value.charAt(value.length() - 1) != ')') {
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(value));
            return organism;
        }
        if (value.endsWith(".") && value.charAt(value.length() - 2) == ')' || value.charAt(value.length() - 1) == ')') {
            // empty if block
        }
        if ((value.endsWith(".") && value.charAt(value.length() - 2) == ')' || value.charAt(value.length() - 1) == ')') && value.indexOf(" (") == -1) {
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(value));
            return organism;
        }
        if (value.endsWith(".")) {
            value = value.substring(0, value.length() - 1);
        }
        String rest = value.trim();
        int strainStart = -1;
        int start = 0;
        int startBracketIndex = -1;
        Map.Entry<String, Integer> pair = OrganismLineParserHelper.containStrain(rest);
        if (pair != null && (start = OrganismLineParserHelper.getEndBlacket(rest, (strainStart = pair.getValue().intValue()) + pair.getKey().length())) == -1) {
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(value));
            return organism;
        }
        startBracketIndex = rest.indexOf("(", start + 1);
        if (startBracketIndex == -1) {
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(value));
            return organism;
        }
        String scientificName = rest.substring(0, startBracketIndex).trim();
        int endBracketIndex = OrganismLineParserHelper.getEndBlacket(rest, startBracketIndex + 1);
        if (endBracketIndex == -1) {
            throw new IllegalArgumentException("organism name: " + organismName + " is not right");
        }
        String commonName = rest.substring(startBracketIndex + 1, endBracketIndex).trim();
        rest = rest.substring(endBracketIndex + 1).trim();
        String synonym = null;
        if (!rest.isEmpty()) {
            startBracketIndex = rest.indexOf("(");
            if (startBracketIndex == -1) {
                throw new IllegalArgumentException("organism name: " + organismName + " is not right");
            }
            endBracketIndex = OrganismLineParserHelper.getEndBlacket(rest, startBracketIndex + 1);
            if (endBracketIndex == -1) {
                throw new IllegalArgumentException("organism name: " + organismName + " is not right");
            }
            synonym = rest.substring(startBracketIndex + 1, endBracketIndex).trim();
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(scientificName));
            organism.setCommonName(DefaultUniProtFactory.getInstance().buildOrganismCommonName(commonName));
            organism.setSynonym(DefaultUniProtFactory.getInstance().buildOrganismSynonym(synonym));
            return organism;
        }
        organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(scientificName));
        organism.setCommonName(DefaultUniProtFactory.getInstance().buildOrganismCommonName(commonName));
        return organism;
    }

    private static Map.Entry<String, Integer> containStrain(String value) {
        int index = value.indexOf(" (");
        if (index == -1) {
            return null;
        }
        String subStr = value.substring(index);
        for (String str : STRAINS) {
            if (!subStr.startsWith(str)) continue;
            return new AbstractMap.SimpleEntry<String, Integer>(str, index);
        }
        return null;
    }

    private static int getEndBlacket(String val, int start) {
        char endC = ')';
        char startC = '(';
        String value = val;
        if (value.endsWith(".")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.charAt(value.length() - 1) != endC) {
            return -1;
        }
        int countStart = 0;
        int countEnd = 0;
        for (int i = start; i < value.length(); ++i) {
            if (value.charAt(i) == endC) {
                if (countStart == countEnd) {
                    return i;
                }
                ++countEnd;
                continue;
            }
            if (value.charAt(i) != startC) continue;
            ++countStart;
        }
        return -1;
    }
}

