/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.cc;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.CcLineParser;
import uk.ac.ebi.uniprot.parser.antlr.CcLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.cc.CcLineObject;

public class CcLineModelListener
extends CcLineParserBaseListener
implements ParseTreeObjectExtractor<CcLineObject> {
    private CcLineObject object;

    private CcLineObject.EvidencedString getEvidencedString(CcLineParser.Cc_properties_text_level2_with_evContext context) {
        String text = context.cc_properties_text_level2().getText().trim();
        List<String> evidence = context.evidence() == null ? null : EvidenceInfo.processEvidence(context.evidence().EV_TAG());
        return CcLineObject.EvidencedString.get(text, evidence);
    }

    private CcLineObject.EvidencedString getEvidencedString(CcLineParser.Cc_properties_note_text_level2_with_evContext context) {
        String text = context.cc_properties_note_text_level2().getText().trim();
        List<String> evidence = context.evidence() == null ? null : EvidenceInfo.processEvidence(context.evidence().EV_TAG());
        return CcLineObject.EvidencedString.get(text, evidence);
    }

    private CcLineObject.EvidencedString getEvidencedString(CcLineParser.Cc_properties_note_text_with_evContext context) {
        String text = context.cc_properties_note_text().getText().trim();
        List<String> evidence = context.evidence() == null ? null : EvidenceInfo.processEvidence(context.evidence().EV_TAG());
        return CcLineObject.EvidencedString.get(text, evidence);
    }

    private CcLineObject.EvidencedString getEvidencedString(CcLineParser.Cc_common_text_with_evContext context) {
        String text = context.cc_common_text().getText().trim();
        List<String> evidence = context.evidence() == null ? null : EvidenceInfo.processEvidence(context.evidence().EV_TAG());
        return CcLineObject.EvidencedString.get(text, evidence);
    }

    private CcLineObject.EvidencedString getEvidenceString(CcLineParser.Cc_alternative_value_with_evidenceContext context) {
        String text = context.cc_alternative_value().getText().trim();
        List<String> evidence = context.evidence() == null ? null : EvidenceInfo.processEvidence(context.evidence().EV_TAG());
        return CcLineObject.EvidencedString.get(text, evidence);
    }

    @Override
    public void exitCc_common(CcLineParser.Cc_commonContext ctx) {
        CcLineObject.CC ccCommon = new CcLineObject.CC();
        TerminalNode terminalNode = ctx.CC_TOPIC_COMMON();
        ccCommon.topic = CcLineObject.CCTopicEnum.fromSting(terminalNode.getText());
        CcLineObject.FreeText ftext = new CcLineObject.FreeText();
        CcLineParser.Cc_common_textsContext ccCommonTextsContext = ctx.cc_common_texts();
        List<CcLineParser.Cc_common_text_with_evContext> ccCommonTextWithEvContexts = ccCommonTextsContext.cc_common_text_with_ev();
        for (CcLineParser.Cc_common_text_with_evContext ftCtx : ccCommonTextWithEvContexts) {
            ftext.texts.add(this.getEvidencedString(ftCtx));
        }
        ccCommon.object = ftext;
        this.object.ccs.add(ccCommon);
    }

    @Override
    public void enterCc_cc(CcLineParser.Cc_ccContext ctx) {
        this.object = new CcLineObject();
    }

    @Override
    public void enterCc_lines(CcLineParser.Cc_linesContext ctx) {
        this.object = new CcLineObject();
    }

    @Override
    public void exitCc_sequence_caution(CcLineParser.Cc_sequence_cautionContext ctx) {
        String mol;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.SEQUENCE_CAUTION;
        CcLineObject.SequenceCaution sc = new CcLineObject.SequenceCaution();
        cc.object = sc;
        this.object.ccs.add(cc);
        CcLineParser.Cc_molecule2Context moleculeCtx = ctx.cc_molecule2();
        if (moleculeCtx != null && (mol = moleculeCtx.getText()) != null && mol.length() > 2) {
            sc.molecule = mol.substring(1, mol.length() - 1);
        }
        List<CcLineParser.Cc_sequence_caution_lineContext> ccSequenceCautionLineContexts = ctx.cc_sequence_caution_line();
        for (CcLineParser.Cc_sequence_caution_lineContext lineContext : ccSequenceCautionLineContexts) {
            CcLineParser.Cc_sequence_caution_evidenceContext ev;
            CcLineObject.SequenceCautionObject object1 = new CcLineObject.SequenceCautionObject();
            sc.sequenceCautionObjects.add(object1);
            CcLineParser.Cc_sequence_caution_sequenceContext ccSequenceCautionSequenceContext = lineContext.cc_sequence_caution_sequence();
            object1.sequence = ccSequenceCautionSequenceContext.CC_SC_SEQUENCE_TEXT().getText();
            if (ccSequenceCautionSequenceContext.evidence() != null) {
                EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), object1.sequence, ccSequenceCautionSequenceContext.evidence().EV_TAG());
            }
            CcLineParser.Cc_sequence_caution_typeContext ccSequenceCautionTypeContext = lineContext.cc_sequence_caution_type();
            object1.type = CcLineObject.SequenceCautionType.fromSting(ccSequenceCautionTypeContext.CC_SC_TYPE_VALUE().getText());
            CcLineParser.Cc_sequence_caution_noteContext ccSequenceCautionNoteContext = lineContext.cc_sequence_caution_note();
            if (ccSequenceCautionNoteContext != null) {
                object1.note = ccSequenceCautionNoteContext.CC_SC_NOTE_TEXT().getText();
            }
            if ((ev = lineContext.cc_sequence_caution_evidence()) == null) continue;
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), object1, ev.EV_TAG());
        }
    }

    @Override
    public void exitCc_mass_spectrometry(CcLineParser.Cc_mass_spectrometryContext ctx) {
        CcLineParser.Cc_mass_spectrometry_mass_sourceContext sourceContext;
        String text1;
        CcLineParser.Cc_mass_spectrometry_mass_errorContext ccMassSpectrometryMassErrorContext;
        CcLineParser.Cc_mass_spectrometry_massContext ccMassSpectrometryMassContext;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.MASS_SPECTROMETRY;
        CcLineObject.MassSpectrometry ms = new CcLineObject.MassSpectrometry();
        cc.object = ms;
        this.object.ccs.add(cc);
        if (ctx.cc_molecule2() != null) {
            String text = ctx.cc_molecule2().getText();
            ms.molecule = text.substring(0, text.length() - 1);
        }
        if ((ccMassSpectrometryMassContext = ctx.cc_mass_spectrometry_mass()) != null) {
            String text = ccMassSpectrometryMassContext.CC_MS_V_NUMBER().getText();
            ms.mass = Float.parseFloat(text);
        }
        if ((ccMassSpectrometryMassErrorContext = ctx.cc_mass_spectrometry_mass_error()) != null) {
            String text12 = ccMassSpectrometryMassErrorContext.CC_MS_V_NUMBER().getText();
            ms.massError = Float.parseFloat(text12);
        }
        CcLineParser.Cc_mass_spectrometry_mass_methodContext ccMassSpectrometryMassMethodContext = ctx.cc_mass_spectrometry_mass_method();
        ms.method = text1 = ccMassSpectrometryMassMethodContext.cc_mass_spectrometry_value().getText();
        CcLineParser.Cc_mass_spectrometry_mass_noteContext noteContext = ctx.cc_mass_spectrometry_mass_note();
        if (noteContext != null) {
            ms.note = noteContext.cc_properties_text().getText();
        }
        if ((sourceContext = ctx.cc_mass_spectrometry_mass_source()) != null) {
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), ms, sourceContext.EV_TAG());
            List<TerminalNode> terminalNodes = sourceContext.EV_TAG();
            for (TerminalNode node : terminalNodes) {
                ms.sources.add(node.getText());
            }
        }
    }

    @Override
    public void exitCc_web_resource(CcLineParser.Cc_web_resourceContext ctx) {
        CcLineParser.Cc_web_resource_noteContext ccWebResourceNoteContext;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.WEB_RESOURCE;
        CcLineObject.WebResource wr = new CcLineObject.WebResource();
        cc.object = wr;
        this.object.ccs.add(cc);
        if (ctx.cc_molecule2() != null) {
            String text = ctx.cc_molecule2().getText();
            wr.molecule = text.substring(0, text.length() - 1);
        }
        CcLineParser.Cc_web_resource_nameContext ccWebResourceNameContext = ctx.cc_web_resource_name();
        wr.name = ccWebResourceNameContext.cc_properties_text().getText();
        CcLineParser.Cc_web_resource_urlContext ccWebResourceUrlContext = ctx.cc_web_resource_url();
        if (ccWebResourceUrlContext != null) {
            String text = ccWebResourceUrlContext.cc_properties_text().getText();
            wr.url = text.substring(1, text.length() - 1);
        }
        if ((ccWebResourceNoteContext = ctx.cc_web_resource_note()) != null) {
            wr.note = ccWebResourceNoteContext.cc_properties_text().getText();
        }
    }

    @Override
    public void exitCc_interaction(CcLineParser.Cc_interactionContext ctx) {
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.INTERACTION;
        CcLineObject.Interaction ir = new CcLineObject.Interaction();
        cc.object = ir;
        this.object.ccs.add(cc);
        List<CcLineParser.Cc_interaction_lineContext> ccInteractionLineContexts = ctx.cc_interaction_line();
        for (CcLineParser.Cc_interaction_lineContext io : ccInteractionLineContexts) {
            CcLineObject.InteractionObject interactionObject = new CcLineObject.InteractionObject();
            CcLineParser.Cc_interaction_firstContext firstInteractantCtx = io.cc_interaction_first();
            interactionObject.firstInteractant = firstInteractantCtx.CC_IR_AC().getText();
            CcLineParser.Cc_interaction_spContext ccInteractionSpContext = io.cc_interaction_sp();
            interactionObject.secondInteractant = ccInteractionSpContext.CC_IR_AC().getText();
            CcLineParser.Cc_interaction_parentContext parentCtx = ccInteractionSpContext.cc_interaction_parent();
            if (parentCtx != null) {
                interactionObject.secondInteractantParent = parentCtx.CC_IR_AC().getText();
            }
            if (ccInteractionSpContext.cc_interaction_gene() != null) {
                interactionObject.gene = ccInteractionSpContext.cc_interaction_gene().getText();
            }
            if (io.cc_interaction_xeno() != null) {
                interactionObject.xeno = true;
            }
            TerminalNode integer = io.cc_interaction_nbexp().INTEGER();
            interactionObject.nbexp = Integer.parseInt(integer.getText());
            CcLineParser.Cc_interaction_intactContext ccInteractionIntactContext = io.cc_interaction_intact();
            interactionObject.firstId = ccInteractionIntactContext.CC_IR_AC(0).getText();
            interactionObject.secondId = ccInteractionIntactContext.CC_IR_AC(1).getText();
            ir.interactions.add(interactionObject);
        }
    }

    @Override
    public void exitCc_biophyiochemical(CcLineParser.Cc_biophyiochemicalContext ctx) {
        String mol;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.BIOPHYSICOCHEMICAL_PROPERTIES;
        CcLineObject.BiophysicochemicalProperties bp = new CcLineObject.BiophysicochemicalProperties();
        cc.object = bp;
        this.object.ccs.add(cc);
        CcLineParser.Cc_molecule2Context moleculeCtx = ctx.cc_molecule2();
        if (moleculeCtx != null && (mol = moleculeCtx.getText()) != null && mol.length() > 2) {
            bp.molecule = mol.substring(1, mol.length() - 1);
        }
        List<CcLineParser.Cc_biophyiochemical_propertiesContext> ctx2 = ctx.cc_biophyiochemical_properties();
        for (CcLineParser.Cc_biophyiochemical_propertiesContext ccBiophyiochemicalPropertiesContext : ctx2) {
            this.processBiophysicalProperties(ccBiophyiochemicalPropertiesContext, bp);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processBiophysicalProperties(CcLineParser.Cc_biophyiochemical_propertiesContext ctx, CcLineObject.BiophysicochemicalProperties bp) {
        List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textWithEvs;
        CcLineParser.Cc_properties_notes_level_2Context c;
        CcLineParser.Cc_biophyiochemical_kineticContext kineticContext;
        if (ctx.cc_biophyiochemical_absorption() != null) {
            CcLineParser.EvidenceContext evidenceContext;
            void var6_8;
            Object text;
            CcLineParser.Cc_biophyiochemical_absorption_basContext absBasContext = ctx.cc_biophyiochemical_absorption().cc_biophyiochemical_absorption_bas();
            CcLineParser.Cc_properties_text_level2_with_evContext textWithEv = absBasContext.cc_properties_text_level2_with_ev();
            Object object = text = textWithEv.cc_properties_text_level2().getText();
            if (((String)text).startsWith("~")) {
                bp.bsorptionAbsApproximate = true;
                String string = ((String)text).substring(1);
            }
            bp.bsorptionAbs = CcLineObject.EvidencedString.get((String)var6_8, (evidenceContext = textWithEv.evidence()) == null ? null : EvidenceInfo.processEvidence(evidenceContext.EV_TAG()));
            CcLineParser.Cc_biophyiochemical_absorption_noteContext absNotContext = ctx.cc_biophyiochemical_absorption().cc_biophyiochemical_absorption_note();
            if (absNotContext != null) {
                CcLineParser.Cc_properties_notes_level_2Context ccPropertiesNotesLevel2Context = absNotContext.cc_properties_notes_level_2();
                List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textWithEvs2 = ccPropertiesNotesLevel2Context.cc_properties_note_text_level2_with_ev();
                for (CcLineParser.Cc_properties_note_text_level2_with_evContext c2 : textWithEvs2) {
                    bp.bsorptionNote.add(this.getEvidencedString(c2));
                }
            }
        }
        if ((kineticContext = ctx.cc_biophyiochemical_kinetic()) != null) {
            List<CcLineParser.Cc_biophyiochemical_kinetic_kmContext> ccBiophyiochemicalKineticKmContexts = kineticContext.cc_biophyiochemical_kinetic_km();
            for (CcLineParser.Cc_biophyiochemical_kinetic_kmContext cc_biophyiochemical_kinetic_kmContext : ccBiophyiochemicalKineticKmContexts) {
                CcLineParser.Cc_properties_text_level2_with_evContext cc_properties_text_level2_with_evContext = cc_biophyiochemical_kinetic_kmContext.cc_properties_text_level2_with_ev();
                bp.kms.add(this.getEvidencedString(cc_properties_text_level2_with_evContext));
            }
            List<CcLineParser.Cc_biophyiochemical_kinetic_bpmaxContext> maxcontext = kineticContext.cc_biophyiochemical_kinetic_bpmax();
            for (CcLineParser.Cc_biophyiochemical_kinetic_bpmaxContext cc_biophyiochemical_kinetic_bpmaxContext : maxcontext) {
                CcLineParser.Cc_properties_text_level2_with_evContext cc = cc_biophyiochemical_kinetic_bpmaxContext.cc_properties_text_level2_with_ev();
                bp.vmaxs.add(this.getEvidencedString(cc));
            }
            CcLineParser.Cc_biophyiochemical_kinetic_noteContext cc_biophyiochemical_kinetic_noteContext = kineticContext.cc_biophyiochemical_kinetic_note();
            if (cc_biophyiochemical_kinetic_noteContext != null) {
                CcLineParser.Cc_properties_notes_level_2Context cc_properties_notes_level_2Context = cc_biophyiochemical_kinetic_noteContext.cc_properties_notes_level_2();
                List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textLevel2WithEvContexts = cc_properties_notes_level_2Context.cc_properties_note_text_level2_with_ev();
                for (CcLineParser.Cc_properties_note_text_level2_with_evContext cc : textLevel2WithEvContexts) {
                    bp.kpNote.add(this.getEvidencedString(cc));
                }
            }
        }
        if (ctx.cc_biophyiochemical_redox() != null) {
            c = ctx.cc_biophyiochemical_redox().cc_properties_notes_level_2();
            textWithEvs = c.cc_properties_note_text_level2_with_ev();
            for (CcLineParser.Cc_properties_note_text_level2_with_evContext cc_properties_note_text_level2_with_evContext : textWithEvs) {
                bp.rdoxPotential.add(this.getEvidencedString(cc_properties_note_text_level2_with_evContext));
            }
        }
        if (ctx.cc_biophyiochemical_ph() != null) {
            c = ctx.cc_biophyiochemical_ph().cc_properties_notes_level_2();
            textWithEvs = c.cc_properties_note_text_level2_with_ev();
            for (CcLineParser.Cc_properties_note_text_level2_with_evContext cc_properties_note_text_level2_with_evContext : textWithEvs) {
                bp.phDependence.add(this.getEvidencedString(cc_properties_note_text_level2_with_evContext));
            }
        }
        if (ctx.cc_biophyiochemical_temperature() != null) {
            CcLineParser.Cc_properties_notes_level_2Context ccPropertiesNotesLevel2Context = ctx.cc_biophyiochemical_temperature().cc_properties_notes_level_2();
            List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textLevel2WithEvContexts = ccPropertiesNotesLevel2Context.cc_properties_note_text_level2_with_ev();
            for (CcLineParser.Cc_properties_note_text_level2_with_evContext cc_properties_note_text_level2_with_evContext : textLevel2WithEvContexts) {
                bp.temperatureDependence.add(this.getEvidencedString(cc_properties_note_text_level2_with_evContext));
            }
        }
    }

    @Override
    public void exitCc_rna_editing(CcLineParser.Cc_rna_editingContext ctx) {
        CcLineParser.Cc_rna_editing_positionContext positionContext;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.RNA_EDITING;
        CcLineObject.RnaEditing re = new CcLineObject.RnaEditing();
        cc.object = re;
        if (ctx.cc_molecule2() != null) {
            String text = ctx.cc_molecule2().getText();
            re.molecule = text.substring(0, text.length() - 1);
        }
        if ((positionContext = ctx.cc_rna_edigint_modified_position().cc_rna_editing_position()) != null) {
            List<CcLineParser.Cc_rna_editing_single_positionContext> singlePosCtxs = positionContext.cc_rna_editing_single_position();
            for (CcLineParser.Cc_rna_editing_single_positionContext sPosCtx : singlePosCtxs) {
                String text = sPosCtx.INTEGER().getText();
                re.locations.add(Integer.parseInt(text));
                if (sPosCtx.evidence() == null) continue;
                EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), text, sPosCtx.evidence().EV_TAG());
            }
        } else if (ctx.cc_rna_edigint_modified_position().cc_re_position_undetermined() != null && ctx.cc_rna_edigint_modified_position().cc_re_position_undetermined().CC_RE_MODIFIED_POSITION_UNDETERMINED() != null) {
            re.locationEnum = CcLineObject.RnaEditingLocationEnum.UNDETERMINED;
            if (ctx.cc_rna_edigint_modified_position().cc_re_position_undetermined().evidence() != null) {
                EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)re.locationEnum, ctx.cc_rna_edigint_modified_position().cc_re_position_undetermined().evidence().EV_TAG());
            }
        } else if (ctx.cc_rna_edigint_modified_position().cc_re_position_not_applicable() != null && ctx.cc_rna_edigint_modified_position().cc_re_position_not_applicable().CC_RE_MODIFIED_POSITION_NOT_APPLICABLE() != null) {
            re.locationEnum = CcLineObject.RnaEditingLocationEnum.NOT_APPLICABLE;
            if (ctx.cc_rna_edigint_modified_position().cc_re_position_not_applicable().evidence() != null) {
                EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)re.locationEnum, ctx.cc_rna_edigint_modified_position().cc_re_position_not_applicable().evidence().EV_TAG());
            }
        }
        if (ctx.cc_rna_edigint_note() != null) {
            CcLineParser.Cc_properties_notesContext ccPropertiesNotesContext = ctx.cc_rna_edigint_note().cc_properties_notes();
            List<CcLineParser.Cc_properties_note_text_with_evContext> ccPropertiesTextWithEvContexts = ccPropertiesNotesContext.cc_properties_note_text_with_ev();
            for (CcLineParser.Cc_properties_note_text_with_evContext c : ccPropertiesTextWithEvContexts) {
                re.note.add(this.getEvidencedString(c));
            }
        }
        this.object.ccs.add(cc);
    }

    @Override
    public void exitCc_subcellular_location(CcLineParser.Cc_subcellular_locationContext ctx) {
        CcLineParser.Cc_subcellular_location_sectionContext ccSubcellularLocationSectionContext;
        CcLineParser.Cc_subcellular_noteContext ccSubcellularNoteContext;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.SUBCELLULAR_LOCATION;
        CcLineObject.SubcullarLocation sl = new CcLineObject.SubcullarLocation();
        cc.object = sl;
        if (ctx.cc_molecule2() != null) {
            String text = ctx.cc_molecule2().getText();
            sl.molecule = text.substring(0, text.length() - 1);
        }
        if ((ccSubcellularNoteContext = ctx.cc_subcellular_note()) != null) {
            CcLineParser.Cc_common_textsContext ccCommonTextsContext = ccSubcellularNoteContext.cc_common_texts();
            List<CcLineParser.Cc_common_text_with_evContext> ccCommonTextWithEvContexts = ccCommonTextsContext.cc_common_text_with_ev();
            for (CcLineParser.Cc_common_text_with_evContext ftCtx : ccCommonTextWithEvContexts) {
                sl.note.add(this.getEvidencedString(ftCtx));
            }
        }
        if ((ccSubcellularLocationSectionContext = ctx.cc_subcellular_location_section()) != null) {
            List<CcLineParser.Cc_subcellular_location_location_with_evidenceContext> ccSubcellularLocationLocationWithEvidenceContexts = ccSubcellularLocationSectionContext.cc_subcellular_location_location_with_evidence();
            for (CcLineParser.Cc_subcellular_location_location_with_evidenceContext locationContext : ccSubcellularLocationLocationWithEvidenceContexts) {
                String replace;
                String text;
                CcLineParser.Cc_subcellular_location_valueContext ccSubcellularLocationValueContext;
                CcLineParser.Cc_subcellular_location_value_with_evidenceContext locEvi;
                CcLineObject.LocationObject locationObject = new CcLineObject.LocationObject();
                CcLineParser.Cc_subcellular_location_locationContext ccSubcellularLocationLocationContext = locationContext.cc_subcellular_location_location();
                List<CcLineParser.Cc_subcellular_location_value_with_evidenceContext> valueContexts = ccSubcellularLocationLocationContext.cc_subcellular_location_value_with_evidence();
                int size = valueContexts.size();
                if (size >= 1) {
                    locEvi = valueContexts.get(0);
                    ccSubcellularLocationValueContext = locEvi.cc_subcellular_location_value();
                    locationObject.subcellularLocation = new CcLineObject.LocationValue();
                    locationObject.subcellularLocation.value = ccSubcellularLocationValueContext.cc_subcellular_words().getText();
                    if (ccSubcellularLocationValueContext.cc_subcellular_location_flag() != null) {
                        text = ccSubcellularLocationValueContext.cc_subcellular_location_flag().CC_SL_FLAG().getText();
                        replace = text.replace("\nCC       ", " ");
                        locationObject.subcellularLocation.flag = CcLineObject.LocationFlagEnum.fromSting(replace.substring(1, replace.length() - 1));
                    }
                    if (locEvi.evidence() != null) {
                        EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), locationObject.subcellularLocation, locEvi.evidence().EV_TAG());
                    }
                }
                if (size >= 2) {
                    locEvi = valueContexts.get(1);
                    ccSubcellularLocationValueContext = locEvi.cc_subcellular_location_value();
                    locationObject.topology = new CcLineObject.LocationValue();
                    locationObject.topology.value = ccSubcellularLocationValueContext.cc_subcellular_words().getText();
                    if (ccSubcellularLocationValueContext.cc_subcellular_location_flag() != null) {
                        text = ccSubcellularLocationValueContext.cc_subcellular_location_flag().CC_SL_FLAG().getText();
                        replace = text.replace("\nCC       ", " ");
                        locationObject.topology.flag = CcLineObject.LocationFlagEnum.fromSting(replace.substring(1, replace.length() - 1));
                    }
                    if (locEvi.evidence() != null) {
                        EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), locationObject.topology, locEvi.evidence().EV_TAG());
                    }
                }
                if (size >= 3) {
                    locEvi = valueContexts.get(2);
                    ccSubcellularLocationValueContext = locEvi.cc_subcellular_location_value();
                    locationObject.orientation = new CcLineObject.LocationValue();
                    locationObject.orientation.value = ccSubcellularLocationValueContext.cc_subcellular_words().getText();
                    if (ccSubcellularLocationValueContext.cc_subcellular_location_flag() != null) {
                        text = ccSubcellularLocationValueContext.cc_subcellular_location_flag().CC_SL_FLAG().getText();
                        replace = text.replace("\nCC       ", " ");
                        locationObject.orientation.flag = CcLineObject.LocationFlagEnum.fromSting(replace.substring(1, replace.length() - 1));
                    }
                    if (locEvi.evidence() != null) {
                        EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), locationObject.orientation, locEvi.evidence().EV_TAG());
                    }
                }
                if (locationContext.evidence() != null) {
                    EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), locationObject, locationContext.evidence().EV_TAG());
                }
                sl.locations.add(locationObject);
            }
        }
        this.object.ccs.add(cc);
    }

    @Override
    public void exitCc_alternative_products(CcLineParser.Cc_alternative_productsContext ctx) {
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.ALTERNATIVE_PRODUCTS;
        CcLineObject.AlternativeProducts ap = new CcLineObject.AlternativeProducts();
        cc.object = ap;
        CcLineParser.Cc_alternative_products_eventContext ccAlternativeProductsEventContext = ctx.cc_alternative_products_event();
        List<CcLineParser.Cc_alternative_valueContext> ccAlternativeValueContexts1 = ccAlternativeProductsEventContext.cc_alternative_products_event_event().cc_alternative_value();
        for (CcLineParser.Cc_alternative_valueContext ccAlternativeValueContext : ccAlternativeValueContexts1) {
            String text = ccAlternativeValueContext.getText();
            ap.events.add(text);
        }
        ap.namedIsoforms = ccAlternativeProductsEventContext.cc_alternative_products_event_namedisoforms().cc_alternative_value().getText();
        if (ccAlternativeProductsEventContext.cc_alternative_products_event_comment() != null) {
            CcLineParser.Cc_properties_notes_level_2Context ccPropertiesNotesLevel2Context = ccAlternativeProductsEventContext.cc_alternative_products_event_comment().cc_properties_notes_level_2();
            List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textLevel2WithEvContexts = ccPropertiesNotesLevel2Context.cc_properties_note_text_level2_with_ev();
            for (CcLineParser.Cc_properties_note_text_level2_with_evContext co : textLevel2WithEvContexts) {
                ap.comment.add(this.getEvidencedString(co));
            }
        }
        List<CcLineParser.Cc_alternative_products_nameContext> ccAlternativeProductsNameContexts = ctx.cc_alternative_products_name();
        for (CcLineParser.Cc_alternative_products_nameContext nameContext : ccAlternativeProductsNameContexts) {
            CcLineParser.Cc_alternative_products_noteContext ccAlternativeProductsNoteContext;
            CcLineObject.AlternativeProductName name = new CcLineObject.AlternativeProductName();
            name.name = this.getEvidenceString(nameContext.cc_alternative_value_with_evidence());
            CcLineParser.Cc_alternative_products_isoidContext ccAlternativeProductsIsoidContext = nameContext.cc_alternative_products_isoid();
            List<CcLineParser.Cc_alternative_valueContext> isos = ccAlternativeProductsIsoidContext.cc_alternative_value();
            for (CcLineParser.Cc_alternative_valueContext ccAlternativeValueContext : isos) {
                name.isoId.add(ccAlternativeValueContext.getText());
            }
            CcLineParser.Cc_alternative_products_sequence_valueContext seqvalueContext = nameContext.cc_alternative_products_sequence().cc_alternative_products_sequence_value();
            if (seqvalueContext.CC_AP_DISPLAYED() != null) {
                name.sequenceEnum = CcLineObject.AlternativeNameSequenceEnum.DISPLAYED;
            } else if (seqvalueContext.CC_AP_EXTERNAL() != null) {
                name.sequenceEnum = CcLineObject.AlternativeNameSequenceEnum.EXTERNAL;
            } else if (seqvalueContext.CC_AP_NOT_DESCRIBED() != null) {
                name.sequenceEnum = CcLineObject.AlternativeNameSequenceEnum.NOT_DESCRIBED;
            } else if (seqvalueContext.CC_AP_VALUE_UNSURE() != null) {
                name.sequenceEnum = CcLineObject.AlternativeNameSequenceEnum.UNSURE;
            } else if (seqvalueContext.CC_AP_DESCRIBED() != null) {
                name.sequenceEnum = CcLineObject.AlternativeNameSequenceEnum.DESCRIBED;
            } else if (seqvalueContext.cc_alternative_products_sequence_value_identifiers() != null) {
                List<TerminalNode> terminalNodes = seqvalueContext.cc_alternative_products_sequence_value_identifiers().CC_AP_FEATURE_IDENTIFIER();
                for (TerminalNode terminalNode : terminalNodes) {
                    String text = terminalNode.getText();
                    name.sequenceFTId.add(text);
                }
            }
            CcLineParser.Cc_alternative_products_synonymsContext synContext = nameContext.cc_alternative_products_synonyms();
            if (synContext != null) {
                TerminalNode terminalNode;
                List<CcLineParser.Cc_alternative_value_with_evidenceContext> ccAlternativeValueContexts = synContext.cc_alternative_value_with_evidence();
                terminalNode = ccAlternativeValueContexts.iterator();
                while (terminalNode.hasNext()) {
                    CcLineParser.Cc_alternative_value_with_evidenceContext ccAlternativeValueContext = terminalNode.next();
                    name.synNames.add(this.getEvidenceString(ccAlternativeValueContext));
                }
            }
            if ((ccAlternativeProductsNoteContext = nameContext.cc_alternative_products_note()) != null) {
                CcLineParser.Cc_properties_notes_level_2Context ccPropertiesNotesLevel2Context = ccAlternativeProductsNoteContext.cc_properties_notes_level_2();
                List<CcLineParser.Cc_properties_note_text_level2_with_evContext> textLevel2WithEvContexts = ccPropertiesNotesLevel2Context.cc_properties_note_text_level2_with_ev();
                for (CcLineParser.Cc_properties_note_text_level2_with_evContext ccc : textLevel2WithEvContexts) {
                    name.note.add(this.getEvidencedString(ccc));
                }
            }
            ap.names.add(name);
        }
        this.object.ccs.add(cc);
    }

    @Override
    public void exitCc_disease(CcLineParser.Cc_diseaseContext ctx) {
        String text;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.DISEASE;
        CcLineObject.Disease dd = new CcLineObject.Disease();
        cc.object = dd;
        if (ctx.cc_molecule2() != null) {
            text = ctx.cc_molecule2().getText();
            dd.molecule = text.substring(0, text.length() - 1);
        }
        if (ctx.cc_disease_name_abbr() != null) {
            text = ctx.cc_disease_name_abbr().getText();
            if (text.endsWith(")") && text.indexOf("(") > 0) {
                int lastB;
                int lastS = text.lastIndexOf(" ");
                if (lastS < 0) {
                    lastS = 0;
                }
                if ((lastB = text.indexOf("(", lastS)) < 0) {
                    lastB = text.indexOf("(");
                }
                dd.name = text.substring(0, lastB).trim();
                dd.abbr = text.substring(lastB + 1, text.length() - 1);
            } else {
                dd.name = text;
            }
            CcLineParser.Cc_disease_mimContext ccDiseaseAbbrMinContext = ctx.cc_disease_mim();
            String text1 = ccDiseaseAbbrMinContext.getText();
            dd.mim = text1.substring(5, text1.length() - 2);
        }
        if (ctx.cc_disease_description() != null) {
            dd.description = ctx.cc_disease_description().cc_disease_text_d().getText();
            if (ctx.cc_disease_description().evidence() != null) {
                EvidenceInfo.processEvidence(this.object.evidenceInfo, dd.description, ctx.cc_disease_description().evidence().EV_TAG());
            }
        }
        if (ctx.cc_disease_note() != null) {
            CcLineParser.Cc_common_textsContext ccCommonTextsContext = ctx.cc_disease_note().cc_common_texts();
            List<CcLineParser.Cc_common_text_with_evContext> ccCommonTextWithEvContexts = ccCommonTextsContext.cc_common_text_with_ev();
            for (CcLineParser.Cc_common_text_with_evContext ftCtx : ccCommonTextWithEvContexts) {
                dd.note.add(this.getEvidencedString(ftCtx));
            }
        }
        this.object.ccs.add(cc);
    }

    @Override
    public void exitCc_cofactor(CcLineParser.Cc_cofactorContext ctx) {
        List<CcLineParser.Cc_cofactor_lineContext> lines;
        CcLineParser.Cc_cofactor_linesContext lineCtx;
        CcLineParser.Cc_cofactor_noteContext note;
        String mol;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.COFACTOR;
        CcLineObject.StructuredCofactor dd = new CcLineObject.StructuredCofactor();
        cc.object = dd;
        CcLineParser.Cc_molecule2Context moleculeCtx = ctx.cc_molecule2();
        if (moleculeCtx != null && (mol = moleculeCtx.getText()) != null && mol.length() > 2) {
            dd.molecule = mol.substring(1, mol.length() - 1);
        }
        if ((note = ctx.cc_cofactor_note()) != null) {
            CcLineParser.Cc_properties_notesContext ccPropertiesNotesContext = note.cc_properties_notes();
            List<CcLineParser.Cc_properties_note_text_with_evContext> ccPropertiesTextWithEvContexts = ccPropertiesNotesContext.cc_properties_note_text_with_ev();
            for (CcLineParser.Cc_properties_note_text_with_evContext ccPropertiesTextWithEvContext : ccPropertiesTextWithEvContexts) {
                dd.note.add(this.getEvidencedString(ccPropertiesTextWithEvContext));
            }
        }
        if ((lineCtx = ctx.cc_cofactor_lines()) != null && !(lines = lineCtx.cc_cofactor_line()).isEmpty()) {
            dd.cofactors = new ArrayList<CcLineObject.CofactorItem>();
            for (CcLineParser.Cc_cofactor_lineContext line : lines) {
                CcLineObject.CofactorItem item = new CcLineObject.CofactorItem();
                item.name = line.cc_cofactor_name().cc_properties_text_level2().getText();
                item.xref = line.cc_cofactor_xref().cc_properties_text_level2().getText();
                CcLineParser.Cc_cofactor_evidenceContext evidenceContext = line.cc_cofactor_evidence();
                if (evidenceContext != null) {
                    EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), item, evidenceContext.EV_TAG());
                }
                dd.cofactors.add(item);
            }
        }
        this.object.ccs.add(cc);
    }

    @Override
    public void exitCc_catalytic_activity(CcLineParser.Cc_catalytic_activityContext ctx) {
        List<CcLineParser.Cc_cat_act_pd_lineContext> lines;
        CcLineParser.Cc_cat_act_pd_linesContext lineCtx;
        CcLineParser.Cc_cat_act_reaction_lineContext reactionLine;
        String mol;
        CcLineObject.CC cc = new CcLineObject.CC();
        cc.topic = CcLineObject.CCTopicEnum.CATALYTIC_ACTIVITY;
        CcLineObject.CatalyticActivity dd = new CcLineObject.CatalyticActivity();
        cc.object = dd;
        CcLineParser.Cc_molecule2Context moleculeCtx = ctx.cc_molecule2();
        if (moleculeCtx != null && (mol = moleculeCtx.getText()) != null && mol.length() > 2) {
            dd.molecule = mol.substring(1, mol.length() - 1);
        }
        if ((reactionLine = ctx.cc_cat_act_reaction_line()) != null) {
            CcLineParser.Cc_cat_act_evidenceContext evidenceContext;
            CcLineObject.CAReaction reaction;
            dd.reaction = reaction = new CcLineObject.CAReaction();
            reaction.name = reactionLine.cc_cat_act_reaction().cc_properties_text_level3().getText();
            if (reactionLine.cc_cat_act_xref() != null) {
                reaction.xref = reactionLine.cc_cat_act_xref().cc_properties_text_level2().getText();
            }
            if (reactionLine.cc_cat_act_ec() != null) {
                reaction.ec = reactionLine.cc_cat_act_ec().cc_properties_text_level2().getText();
            }
            if ((evidenceContext = reactionLine.cc_cat_act_evidence()) != null) {
                EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), reaction, evidenceContext.EV_TAG());
            }
        }
        if ((lineCtx = ctx.cc_cat_act_pd_lines()) != null && !(lines = lineCtx.cc_cat_act_pd_line()).isEmpty()) {
            dd.physiologicalDirections = new ArrayList<CcLineObject.CAPhysioDirection>();
            for (CcLineParser.Cc_cat_act_pd_lineContext line : lines) {
                CcLineObject.CAPhysioDirection item = new CcLineObject.CAPhysioDirection();
                item.name = line.cc_cat_act_pd().cc_properties_text_level2().getText();
                item.xref = line.cc_cat_act_pd_xref().cc_properties_text_level2().getText();
                CcLineParser.Cc_cat_act_pd_evidenceContext evidenceContext = line.cc_cat_act_pd_evidence();
                if (evidenceContext != null) {
                    EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), item, evidenceContext.EV_TAG());
                }
                dd.physiologicalDirections.add(item);
            }
        }
        this.object.ccs.add(cc);
    }

    @Override
    public CcLineObject getObject() {
        return this.object;
    }
}

