/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.cc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseAcronym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.cc.CcLineObject;
import uk.ac.ebi.uniprot.parser.impl.cc.CcLineUtils;

public class CcLineConverter
extends EvidenceIdCollector
implements Converter<CcLineObject, List<Comment>> {
    private final DefaultCommentFactory factory = DefaultCommentFactory.getInstance();
    private static final String STOP = ".";

    @Override
    public List<Comment> convert(CcLineObject f) {
        Map<Object, List<EvidenceId>> evidences = EvidenceHelper.convert(f.getEvidenceInfo());
        this.addAll(evidences.values());
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (CcLineObject.CC cc : f.ccs) {
            if (cc.topic == CcLineObject.CCTopicEnum.SEQUENCE_CAUTION) {
                List<SequenceCautionComment> scComments = this.convertSequenceCaution(cc, evidences);
                for (SequenceCautionComment comment : scComments) {
                    EvidenceHelper.setEvidences(comment, evidences, cc);
                }
                comments.addAll(scComments);
                continue;
            }
            Object gcomment = this.convert(cc, evidences);
            EvidenceHelper.setEvidences(gcomment, evidences, cc);
            comments.add((Comment)gcomment);
        }
        return comments;
    }

    private List<SequenceCautionComment> convertSequenceCaution(CcLineObject.CC cc, Map<Object, List<EvidenceId>> evidences) {
        ArrayList<SequenceCautionComment> comments = new ArrayList<SequenceCautionComment>();
        if (cc.topic != CcLineObject.CCTopicEnum.SEQUENCE_CAUTION) {
            return comments;
        }
        CcLineObject.SequenceCaution seqC = (CcLineObject.SequenceCaution)cc.object;
        for (CcLineObject.SequenceCautionObject cObj : seqC.sequenceCautionObjects) {
            SequenceCautionComment comment = (SequenceCautionComment)this.factory.buildComment(CommentType.SEQUENCE_CAUTION);
            if (seqC.molecule != null) {
                comment.setMolecule(seqC.molecule);
            }
            if (cObj.note != null && !cObj.note.isEmpty()) {
                comment.setNote(this.factory.buildSequenceCautionCommentNote(cObj.note));
            }
            if (cObj.sequence != null) {
                comment.setSequence(cObj.sequence);
            }
            EvidenceHelper.setEvidences(comment, evidences, cObj);
            comment.setType(this.convertSequenceCautionType(cObj.type));
            comments.add(comment);
        }
        return comments;
    }

    private SequenceCautionType convertSequenceCautionType(CcLineObject.SequenceCautionType type) {
        switch (type) {
            case FRAMESHIFT: {
                return SequenceCautionType.FRAMESHIFT;
            }
            case ERRONEOUS_INITIATION: {
                return SequenceCautionType.ERRONEOUS_INITIATION;
            }
            case ERRONEOUS_TERMINATION: {
                return SequenceCautionType.ERRONEOUS_TERMIINATION;
            }
            case ERRONEOUS_GENE_MODEL_PREDICTION: {
                return SequenceCautionType.ERRONEOUS_PREDICTION;
            }
            case ERRONEOUS_TRANSLATION: {
                return SequenceCautionType.ERRONEOUS_TRANSLATION;
            }
            case MISCELLANEOUS_DISCREPANCY: {
                return SequenceCautionType.MISCELLANEOUS_DISCREPANCY;
            }
        }
        return SequenceCautionType.UNKNOWN;
    }

    private <T extends Comment> T convert(CcLineObject.CC cc, Map<Object, List<EvidenceId>> evidences) {
        CcLineObject.CCTopicEnum topic = cc.topic;
        CommentType type = this.convert(topic);
        Object comment = this.factory.buildComment(type);
        switch (topic) {
            case ALTERNATIVE_PRODUCTS: {
                this.updateAlternativeProduct((AlternativeProductsComment)comment, (CcLineObject.AlternativeProducts)cc.object);
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                this.updateBiophyChem((BioPhysicoChemicalPropertiesComment)comment, (CcLineObject.BiophysicochemicalProperties)cc.object);
                break;
            }
            case WEB_RESOURCE: {
                this.updateWebResource((WebResourceComment)comment, (CcLineObject.WebResource)cc.object);
                break;
            }
            case INTERACTION: {
                this.updateInteraction((InteractionComment)comment, (CcLineObject.Interaction)cc.object);
                break;
            }
            case DISEASE: {
                this.updateDisease((DiseaseCommentStructured)comment, (CcLineObject.Disease)cc.object, evidences);
                break;
            }
            case MASS_SPECTROMETRY: {
                this.updateMassSpectrometry((MassSpectrometryComment)comment, (CcLineObject.MassSpectrometry)cc.object);
                break;
            }
            case SUBCELLULAR_LOCATION: {
                this.updateSubcellularLocation((SubcellularLocationComment)comment, (CcLineObject.SubcullarLocation)cc.object, evidences);
                break;
            }
            case RNA_EDITING: {
                this.updateRNAEditing((RnaEditingComment)comment, (CcLineObject.RnaEditing)cc.object, evidences);
                break;
            }
            case COFACTOR: {
                this.updateCofactor((CofactorCommentStructured)comment, (CcLineObject.StructuredCofactor)cc.object, evidences);
                break;
            }
            case CATALYTIC_ACTIVITY: {
                this.updateCatalyticActivity((CatalyticActivityCommentStructured)comment, (CcLineObject.CatalyticActivity)cc.object, evidences);
                break;
            }
            default: {
                this.updateTextOnly((TextOnlyComment)comment, (CcLineObject.FreeText)cc.object);
            }
        }
        return comment;
    }

    private <T> boolean isNotEmpty(List<T> value) {
        return value != null && !value.isEmpty();
    }

    private void updateAlternativeProduct(AlternativeProductsComment comment, CcLineObject.AlternativeProducts cObj) {
        cObj.events.forEach(event -> comment.getEvents().add(this.factory.buildAlternativeProductsEvent((String)event)));
        if (this.isNotEmpty(cObj.comment)) {
            AlternativeProductsCommentComment commentComment = this.factory.buildAlternativeProductsCommentComment();
            commentComment.setTexts(this.convert(cObj.comment));
            comment.setComment(commentComment);
        }
        comment.setIsoforms(cObj.names.stream().map(name -> this.convertAlternativeProductsIsoform((CcLineObject.AlternativeProductName)name)).collect(Collectors.toList()));
    }

    private AlternativeProductsIsoform convertAlternativeProductsIsoform(CcLineObject.AlternativeProductName name) {
        AlternativeProductsIsoform aPIsoform = this.factory.buildAlternativeProductsIsoform();
        IsoformName isoformName = this.factory.buildIsoformName(name.name.value);
        isoformName.setEvidenceIds(EvidenceHelper.convert(name.name.evidences));
        this.add(isoformName.getEvidenceIds());
        aPIsoform.setName(isoformName);
        if (this.isNotEmpty(name.note)) {
            IsoformNote note = this.factory.buildIsoformNote();
            note.setTexts(this.convert(name.note));
            aPIsoform.setNote(note);
        }
        ArrayList<IsoformId> isoIds = new ArrayList<IsoformId>();
        for (String isoId : name.isoId) {
            isoIds.add(this.factory.buildIsoformId(isoId));
        }
        aPIsoform.setIds(isoIds);
        aPIsoform.setSynonyms(name.synNames.stream().map(syn -> {
            IsoformSynonym isoformSyn = this.factory.buildIsoformSynonym(syn.value);
            isoformSyn.setEvidenceIds(EvidenceHelper.convert(syn.evidences));
            this.add(isoformSyn.getEvidenceIds());
            return isoformSyn;
        }).collect(Collectors.toList()));
        ArrayList<IsoformSequenceId> isoSeqIds = new ArrayList<IsoformSequenceId>();
        for (String featId : name.sequenceFTId) {
            isoSeqIds.add(this.factory.buildIsoformSequenceId(featId));
        }
        aPIsoform.setSequenceIds(isoSeqIds);
        aPIsoform.setIsoformSequenceStatus(this.convertIsoformSequenceStatus(name.sequenceEnum));
        return aPIsoform;
    }

    private IsoformSequenceStatus convertIsoformSequenceStatus(CcLineObject.AlternativeNameSequenceEnum type) {
        if (type == null) {
            return IsoformSequenceStatus.DESCRIBED;
        }
        switch (type) {
            case DISPLAYED: {
                return IsoformSequenceStatus.DISPLAYED;
            }
            case EXTERNAL: {
                return IsoformSequenceStatus.EXTERNAL;
            }
            case NOT_DESCRIBED: {
                return IsoformSequenceStatus.NOT_DESCRIBED;
            }
        }
        return IsoformSequenceStatus.DISPLAYED;
    }

    private MichaelisConstant convertMichaelisConstant(CcLineObject.EvidencedString kmEvStr) {
        String kmStr = kmEvStr.value;
        MichaelisConstant km = this.factory.buildMichaelisConstant();
        int index = kmStr.indexOf(32);
        String val = kmStr.substring(0, index).trim();
        kmStr = kmStr.substring(index + 1).trim();
        index = kmStr.indexOf(32);
        String unit = kmStr.substring(0, index).trim();
        kmStr = kmStr.substring(index + 5).trim();
        double value = Double.parseDouble(val);
        km.setConstantStr(val);
        km.setConstant((float)value);
        km.setUnit(MichaelisConstantUnit.convert(unit));
        km.setSubstrate(this.factory.buildSubstrate(kmStr));
        km.setEvidenceIds(EvidenceHelper.convert(kmEvStr.evidences));
        return km;
    }

    private MaximumVelocity convertMaximumVelocity(CcLineObject.EvidencedString vmaxEvStr) {
        String vmaxStr = vmaxEvStr.value;
        MaximumVelocity mv = this.factory.buildMaximumVelocity();
        int index = vmaxStr.indexOf(32);
        String val = vmaxStr.substring(0, index).trim();
        vmaxStr = vmaxStr.substring(index + 1).trim();
        index = vmaxStr.indexOf(32);
        String unit = vmaxStr.substring(0, index).trim();
        vmaxStr = vmaxStr.substring(index + 1).trim();
        double value = Double.parseDouble(val);
        mv.setVelocityStr(val);
        mv.setMaxVelocityUnit(this.factory.buildMaxVelocityUnit(unit));
        mv.setVelocity((float)value);
        mv.setEnzyme(this.factory.buildEnzyme(vmaxStr));
        mv.setEvidenceIds(EvidenceHelper.convert(vmaxEvStr.evidences));
        return mv;
    }

    private void updateBiophyChem(BioPhysicoChemicalPropertiesComment comment, CcLineObject.BiophysicochemicalProperties cObj) {
        if (cObj.molecule != null) {
            comment.setMolecule(cObj.molecule);
        }
        if (this.isNotEmpty(cObj.kms) || this.isNotEmpty(cObj.vmaxs) || this.isNotEmpty(cObj.kpNote)) {
            KineticParameters kp = this.factory.buildKineticParameters();
            cObj.kms.stream().map(kmEvStr -> this.convertMichaelisConstant((CcLineObject.EvidencedString)kmEvStr)).forEach(km -> {
                this.add(km.getEvidenceIds());
                kp.getMichaelisConstants().add((MichaelisConstant)km);
            });
            cObj.vmaxs.stream().map(vmaxEvStr -> this.convertMaximumVelocity((CcLineObject.EvidencedString)vmaxEvStr)).forEach(mv -> {
                this.add(mv.getEvidenceIds());
                kp.getMaximumVelocities().add((MaximumVelocity)mv);
            });
            if (this.isNotEmpty(cObj.kpNote)) {
                KineticParameterNote note = this.factory.buildKineticParameterNote();
                note.setTexts(this.convert(cObj.kpNote));
                kp.setNote(note);
            }
            comment.setKineticParameters(kp);
        }
        if (this.isNotEmpty(cObj.phDependence)) {
            PHDependence phDependence = this.factory.buildPHDependence();
            phDependence.setTexts(this.convert(cObj.phDependence));
            comment.setPHDepencence(phDependence);
        }
        if (this.isNotEmpty(cObj.rdoxPotential)) {
            RedoxPotential redoxPotential = this.factory.buildRedoxPotential();
            redoxPotential.setTexts(this.convert(cObj.rdoxPotential));
            comment.setRedoxPotential(redoxPotential);
        }
        if (this.isNotEmpty(cObj.temperatureDependence)) {
            TemperatureDependence temperatureDependence = this.factory.buildTemperatureDependence();
            temperatureDependence.setTexts(this.convert(cObj.temperatureDependence));
            comment.setTemperatureDependence(temperatureDependence);
        }
        if (cObj.bsorptionAbs != null) {
            Absorption absorption = this.factory.buildAbsorption();
            String abs = cObj.bsorptionAbs.value;
            int index = abs.indexOf(32);
            if (index != -1) {
                abs = abs.substring(0, index).trim();
            }
            absorption.setMax(Integer.parseInt(abs));
            absorption.setEvidenceIds(EvidenceHelper.convert(cObj.bsorptionAbs.evidences));
            this.add(absorption.getEvidenceIds());
            if (this.isNotEmpty(cObj.bsorptionNote)) {
                AbsorptionNote note = this.factory.buildAbsorptionNote();
                note.setTexts(this.convert(cObj.bsorptionNote));
                absorption.setNote(note);
            }
            absorption.setApproximation(cObj.bsorptionAbsApproximate);
            comment.setAbsorption(absorption);
        }
    }

    private void updateWebResource(WebResourceComment comment, CcLineObject.WebResource cObj) {
        comment.setDatabaseName(this.factory.buildDatabaseName(cObj.name));
        if (!Strings.isNullOrEmpty((String)cObj.note)) {
            comment.setDatabaseNote(this.factory.buildDatabaseNote(cObj.note));
        }
        if (cObj.url.startsWith("ftp")) {
            comment.setDatabaseFTP(this.factory.buildDatabaseFTP(cObj.url));
        } else {
            comment.setDatabaseURL(this.factory.buildDatabaseURL(cObj.url));
        }
        if (!Strings.isNullOrEmpty((String)cObj.molecule)) {
            comment.setMolecule(cObj.molecule);
        }
    }

    private void updateInteraction(InteractionComment comment, CcLineObject.Interaction cObj) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        for (CcLineObject.InteractionObject io : cObj.interactions) {
            Interaction interaction = this.factory.buildInteraction();
            interaction.setFirstInteractant(this.factory.buildInteractorUniProtId(io.firstInteractant));
            interaction.setSecondInteractant(this.factory.buildInteractorUniProtId(io.secondInteractant));
            if (io.secondInteractantParent != null) {
                interaction.setSecondInteractantParent(this.factory.buildInteractorUniProtId(io.secondInteractantParent));
            }
            if (!Strings.isNullOrEmpty((String)io.gene)) {
                interaction.setInteractionGeneName(this.factory.buildInteractionGeneName(io.gene));
            }
            if (io.xeno) {
                interaction.setInteractionType(InteractionType.XENO);
            } else {
                interaction.setInteractionType(InteractionType.BINARY);
            }
            interaction.setFirstInteractor(this.factory.buildIntActAccession(io.firstId));
            if (!Strings.isNullOrEmpty((String)io.secondId)) {
                interaction.setSecondInteractor(this.factory.buildIntActAccession(io.secondId));
            }
            interaction.setNumberOfExperiments(io.nbexp);
            interactions.add(interaction);
        }
        comment.setInteractions(interactions);
    }

    private void updateDisease(DiseaseCommentStructured comment, CcLineObject.Disease cObj, Map<Object, List<EvidenceId>> evidences) {
        if (!Strings.isNullOrEmpty((String)cObj.molecule)) {
            comment.setMolecule(cObj.molecule);
        }
        if (!Strings.isNullOrEmpty((String)cObj.name)) {
            Disease disease = this.factory.buildDisease();
            DiseaseId id = this.factory.buildDiseaseId();
            id.setValue(cObj.name);
            disease.setDiseaseId(id);
            if (!Strings.isNullOrEmpty((String)cObj.abbr)) {
                DiseaseAcronym da = this.factory.buildDiseaseAcronym();
                da.setValue(cObj.abbr);
                disease.setDiseaseAcronym(da);
            }
            if (!Strings.isNullOrEmpty((String)cObj.mim)) {
                DiseaseReference dr = this.factory.buildDiseaseReference();
                dr.setDiseaseReferenceType(DiseaseReferenceType.MIM);
                DiseaseReferenceId drId = this.factory.buildDiseaseReferenceId();
                drId.setValue(cObj.mim);
                dr.setDiseaseReferenceId(drId);
                disease.setDiseaseReference(dr);
            }
            if (!Strings.isNullOrEmpty((String)cObj.description)) {
                DiseaseDescription diseaseDescr = this.factory.buildDiseaseDescription();
                String descr = cObj.description;
                if (!descr.endsWith(STOP)) {
                    descr = descr + STOP;
                }
                diseaseDescr.setValue(descr);
                EvidenceHelper.setEvidences(diseaseDescr, evidences, cObj.description);
                disease.setDiseaseDescription(diseaseDescr);
            }
            comment.setDisease(disease);
        }
        if (this.isNotEmpty(cObj.note)) {
            DiseaseNote diseaseNote = this.factory.buildDiseaseNote();
            diseaseNote.setTexts(this.convert(cObj.note));
            comment.setNote(diseaseNote);
        }
    }

    private void updateSubcellularLocation(SubcellularLocationComment comment, CcLineObject.SubcullarLocation cObj, Map<Object, List<EvidenceId>> evidences) {
        if (cObj.molecule != null) {
            comment.setMolecule(cObj.molecule);
        }
        ArrayList<SubcellularLocation> locations = new ArrayList<SubcellularLocation>();
        for (CcLineObject.LocationObject lo : cObj.locations) {
            List<EvidenceId> evids2;
            SubcellularLocationValue topologyVal;
            SubcellularLocationValue orientationVal;
            SubcellularLocation location = this.factory.buildSubcellularLocation();
            locations.add(location);
            SubcellularLocationValue locationVal = this.createSubcellularLocationValue(lo.subcellularLocation, evidences);
            if (locationVal != null) {
                location.setLocation(locationVal);
            }
            if ((orientationVal = this.createSubcellularLocationValue(lo.orientation, evidences)) != null) {
                location.setOrientation(orientationVal);
            }
            if ((topologyVal = this.createSubcellularLocationValue(lo.topology, evidences)) != null) {
                location.setTopology(topologyVal);
            }
            if ((evids2 = evidences.get(lo)) == null || evids2.isEmpty()) continue;
            EvidenceHelper.setEvidences(comment, evidences, lo);
        }
        comment.setSubcellularLocations(locations);
        if (cObj.note != null && !cObj.note.isEmpty()) {
            SubcellularLocationNote note = this.factory.buildSubcellularLocationNote();
            note.setTexts(this.convert(cObj.note));
            comment.setSubcellularLocationNote(note);
        }
    }

    private SubcellularLocationValue createSubcellularLocationValue(CcLineObject.LocationValue locationValue, Map<Object, List<EvidenceId>> evidences) {
        if (locationValue == null || locationValue.value.isEmpty()) {
            return null;
        }
        SubcellularLocationValue subLocationValue = this.factory.buildSubcellularLocationValue();
        subLocationValue.setValue(locationValue.value);
        this.setStatus(subLocationValue, locationValue.flag);
        EvidenceHelper.setEvidences(subLocationValue, evidences, locationValue);
        return subLocationValue;
    }

    private void setStatus(HasCommentStatus hasStatus, CcLineObject.LocationFlagEnum locationflag) {
        if (locationflag == null) {
            hasStatus.setCommentStatus(CommentStatus.EXPERIMENTAL);
            return;
        }
        switch (locationflag) {
            case BY_SIMILARITY: {
                hasStatus.setCommentStatus(CommentStatus.BY_SIMILARITY);
                break;
            }
            case PROBABLE: {
                hasStatus.setCommentStatus(CommentStatus.PROBABLE);
                break;
            }
            case POTENTIAL: {
                hasStatus.setCommentStatus(CommentStatus.POTENTIAL);
                break;
            }
            default: {
                hasStatus.setCommentStatus(CommentStatus.EXPERIMENTAL);
            }
        }
    }

    private void updateMassSpectrometry(MassSpectrometryComment comment, CcLineObject.MassSpectrometry cObj) {
        if (cObj.molecule != null) {
            comment.setMolecule(cObj.molecule);
        }
        comment.setMethod(MassSpectrometryMethod.toType(cObj.method));
        comment.setMolWeight(cObj.mass);
        comment.setMolWeightError(cObj.massError);
        if (!Strings.isNullOrEmpty((String)cObj.note)) {
            comment.setNote(this.factory.buildMassSpectrometryCommentNote(cObj.note));
        }
        ArrayList<MassSpectrometryCommentSource> sources = new ArrayList<MassSpectrometryCommentSource>();
        for (String source : cObj.sources) {
            sources.add(this.factory.buildMassSpectrometryCommentSource(source));
            EvidenceId evId = DefaultEvidenceFactory.getInstance().buildEvidenceId(source);
            comment.getEvidenceIds().add(evId);
        }
        comment.setSources(sources);
    }

    private void updateRNAEditing(RnaEditingComment comment, CcLineObject.RnaEditing cObj, Map<Object, List<EvidenceId>> evidences) {
        if (cObj.molecule != null) {
            comment.setMolecule(cObj.molecule);
        }
        if (cObj.locations.isEmpty()) {
            if (cObj.locationEnum == CcLineObject.RnaEditingLocationEnum.UNDETERMINED) {
                comment.setLocationType(RnaEditingLocationType.Undetermined);
            } else if (cObj.locationEnum == CcLineObject.RnaEditingLocationEnum.NOT_APPLICABLE) {
                comment.setLocationType(RnaEditingLocationType.Not_applicable);
            }
        } else {
            comment.setLocationType(RnaEditingLocationType.Known);
            comment.setPositions(cObj.locations.stream().map(pos -> this.convertRNAEditingPosition((int)pos, evidences)).collect(Collectors.toList()));
        }
        if (this.isNotEmpty(cObj.note)) {
            RnaEditingNote note = this.factory.buildRnaEditingNote();
            note.setTexts(this.convert(cObj.note, true));
            comment.setRnaEditingNote(note);
        }
    }

    private Position convertRNAEditingPosition(int pos, Map<Object, List<EvidenceId>> evidences) {
        Position position = this.factory.buildRnaEditingPosition();
        String spos = "" + pos;
        position.setPosition(spos);
        EvidenceHelper.setEvidences(position, evidences, spos);
        return position;
    }

    private void updateTextOnly(TextOnlyComment comment, CcLineObject.FreeText cObj) {
        ArrayList<CommentText> cTexts = new ArrayList<CommentText>();
        boolean first = true;
        for (CcLineObject.EvidencedString val : cObj.texts) {
            CommentText text = this.factory.buildCommentText();
            String value = val.value;
            if (first) {
                first = false;
                List<String> result = CcLineUtils.parseFreeText(value);
                value = result.get(1);
                String molecule = result.get(0);
                comment.setMolecule(molecule);
            }
            value = this.setCommentStatus(value, text);
            text.setValue(value);
            text.setEvidenceIds(EvidenceHelper.convert(val.evidences));
            this.add(text.getEvidenceIds());
            cTexts.add(text);
        }
        comment.setTexts(cTexts);
    }

    private void updateCofactor(CofactorCommentStructured comment, CcLineObject.StructuredCofactor cobj, Map<Object, List<EvidenceId>> evidences) {
        if (cobj.molecule != null) {
            comment.setMolecule(cobj.molecule);
        }
        if (cobj.note != null && !cobj.note.isEmpty()) {
            CofactorNote note = this.factory.buildCofactorNote();
            note.setTexts(this.convert(cobj.note, true));
            comment.setNote(note);
        }
        if (cobj.cofactors != null) {
            comment.setCofactors(cobj.cofactors.stream().map(item -> this.convertCofactor((CcLineObject.CofactorItem)item, evidences)).collect(Collectors.toList()));
        }
    }

    private Cofactor convertCofactor(CcLineObject.CofactorItem item, Map<Object, List<EvidenceId>> evidences) {
        Cofactor cofactor = this.factory.buildCofactor();
        cofactor.setName(item.name);
        cofactor.setCofactorReference(this.createCofactorReference(item.xref));
        EvidenceHelper.setEvidences(cofactor, evidences, item);
        return cofactor;
    }

    private CofactorReference createCofactorReference(String val) {
        CofactorReference ref = this.factory.buildCofactorReference();
        int index = val.indexOf(58);
        String type = val.substring(0, index);
        String id = val.substring(index + 1);
        ref.setCofactorReferenceType(CofactorReferenceType.typeOf(type));
        ref.setReferenceId(id);
        return ref;
    }

    private void updateCatalyticActivity(CatalyticActivityCommentStructured comment, CcLineObject.CatalyticActivity object, Map<Object, List<EvidenceId>> evidences) {
        if (object.molecule != null) {
            comment.setMolecule(object.molecule);
        }
        comment.setReaction(this.convertReaction(object.reaction, evidences));
        comment.setPhysiologicalReactions(object.physiologicalDirections.stream().map(val -> this.convertPhysiologicalDirection((CcLineObject.CAPhysioDirection)val, evidences)).collect(Collectors.toList()));
    }

    private PhysiologicalReaction convertPhysiologicalDirection(CcLineObject.CAPhysioDirection capd, Map<Object, List<EvidenceId>> evidences) {
        PhysiologicalReaction direction = this.factory.buildPhysiologicalReaction();
        if (capd.xref != null) {
            direction.setReactionReference(this.convertReactionReference(capd.xref));
        }
        direction.setDirectionType(PhysiologicalDirectionType.typeOf(capd.name));
        EvidenceHelper.setEvidences(direction, evidences, capd);
        return direction;
    }

    private Reaction convertReaction(CcLineObject.CAReaction caReaction, Map<Object, List<EvidenceId>> evidences) {
        Reaction reaction = this.factory.buildReaction();
        reaction.setName(caReaction.name);
        if (caReaction.ec != null) {
            reaction.setECNumber(caReaction.ec);
        }
        if (!Strings.isNullOrEmpty((String)caReaction.xref)) {
            reaction.setReactionReferences(Arrays.stream(caReaction.xref.split(", ")).map(this::convertReactionReference).collect(Collectors.toList()));
        }
        EvidenceHelper.setEvidences(reaction, evidences, caReaction);
        return reaction;
    }

    private ReactionReference convertReactionReference(String val) {
        ReactionReference ref = this.factory.buildReactionReference();
        int index = val.indexOf(58);
        String type = val.substring(0, index);
        String id = val.substring(index + 1);
        ref.setType(ReactionReferenceType.typeOf(type));
        ref.setId(id);
        return ref;
    }

    private String setCommentStatus(String annotation, HasCommentStatus comment) {
        comment.setCommentStatus(CommentStatus.EXPERIMENTAL);
        return annotation;
    }

    private List<EvidencedValue> convert(List<CcLineObject.EvidencedString> val, boolean trimTrailStop) {
        return val.stream().map(evStr -> this.convertEvidencedValue((CcLineObject.EvidencedString)evStr, trimTrailStop)).collect(Collectors.toList());
    }

    private EvidencedValue convertEvidencedValue(CcLineObject.EvidencedString evStr, boolean trimTrailStop) {
        EvidencedValue evVal = DefaultUniProtFactory.getInstance().buildEvidencedValue();
        if (trimTrailStop) {
            evVal.setValue(CommentTranslatorHelper.stripTrailing(evStr.value.trim(), STOP));
        } else {
            evVal.setValue(evStr.value.trim());
        }
        evVal.setEvidenceIds(EvidenceHelper.convert(evStr.evidences));
        this.add(evVal.getEvidenceIds());
        return evVal;
    }

    @Override
    private List<EvidencedValue> convert(List<CcLineObject.EvidencedString> val) {
        return this.convert(val, false);
    }

    @Override
    private CommentType convert(CcLineObject.CCTopicEnum topic) {
        CommentType type = CommentType.UNKNOWN;
        switch (topic) {
            case ALLERGEN: {
                type = CommentType.ALLERGEN;
                break;
            }
            case BIOTECHNOLOGY: {
                type = CommentType.BIOTECHNOLOGY;
                break;
            }
            case CATALYTIC_ACTIVITY: {
                type = CommentType.CATALYTIC_ACTIVITY;
                break;
            }
            case CAUTION: {
                type = CommentType.CAUTION;
                break;
            }
            case COFACTOR: {
                type = CommentType.COFACTOR;
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                type = CommentType.DEVELOPMENTAL_STAGE;
                break;
            }
            case DISEASE: {
                type = CommentType.DISEASE;
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                type = CommentType.DISRUPTION_PHENOTYPE;
                break;
            }
            case DOMAIN: {
                type = CommentType.DOMAIN;
                break;
            }
            case ENZYME_REGULATION: {
                type = CommentType.ACTIVITY_REGULATION;
                break;
            }
            case FUNCTION: {
                type = CommentType.FUNCTION;
                break;
            }
            case INDUCTION: {
                type = CommentType.INDUCTION;
                break;
            }
            case MISCELLANEOUS: {
                type = CommentType.MISCELLANEOUS;
                break;
            }
            case PATHWAY: {
                type = CommentType.PATHWAY;
                break;
            }
            case PHARMACEUTICAL: {
                type = CommentType.PHARMACEUTICAL;
                break;
            }
            case POLYMORPHISM: {
                type = CommentType.POLYMORPHISM;
                break;
            }
            case PTM: {
                type = CommentType.PTM;
                break;
            }
            case SIMILARITY: {
                type = CommentType.SIMILARITY;
                break;
            }
            case SUBUNIT: {
                type = CommentType.SUBUNIT;
                break;
            }
            case TISSUE_SPECIFICITY: {
                type = CommentType.TISSUE_SPECIFICITY;
                break;
            }
            case TOXIC_DOSE: {
                type = CommentType.TOXIC_DOSE;
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                type = CommentType.ALTERNATIVE_PRODUCTS;
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                type = CommentType.BIOPHYSICOCHEMICAL_PROPERTIES;
                break;
            }
            case WEB_RESOURCE: {
                type = CommentType.WEBRESOURCE;
                break;
            }
            case INTERACTION: {
                type = CommentType.INTERACTION;
                break;
            }
            case SUBCELLULAR_LOCATION: {
                type = CommentType.SUBCELLULAR_LOCATION;
                break;
            }
            case MASS_SPECTROMETRY: {
                type = CommentType.MASS_SPECTROMETRY;
                break;
            }
            case RNA_EDITING: {
                type = CommentType.RNA_EDITING;
                break;
            }
            default: {
                type = CommentType.UNKNOWN;
            }
        }
        return type;
    }
}

