/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.util;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.util.RetryException;

public class RetryOperation<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int maxAttempts;
    private int secondToWait;
    private int attemptCounter;

    public RetryOperation(int maxAttempts, int secondsToWait) {
        this(maxAttempts);
        Preconditions.checkArgument((secondsToWait >= 0 ? 1 : 0) != 0, (Object)"The number of seconds to wait between retries should be greater or equal to 0 ");
        this.secondToWait = secondsToWait * 1000;
    }

    public RetryOperation(int maxAttempts) {
        Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"Number of retry attempts should be greater than 1");
        this.maxAttempts = maxAttempts;
        this.attemptCounter = 0;
    }

    public T run(Operation<T> operation) {
        try {
            return operation.execute();
        }
        catch (Exception e) {
            return this.retry(operation);
        }
    }

    private T retry(Operation<T> operation) {
        while (this.attemptCounter < this.maxAttempts) {
            ++this.attemptCounter;
            try {
                this.logger.info("Retrying attempt #{}:", (Object)this.attemptCounter);
                return operation.execute();
            }
            catch (Exception e) {
                this.logger.warn("Retry attempt #{} failed:", (Object)this.attemptCounter, (Object)e);
                try {
                    Thread.sleep(this.secondToWait);
                }
                catch (InterruptedException e1) {
                    this.logger.trace("Error occurred whilst sleeping", (Throwable)e1);
                }
            }
        }
        throw new RetryException("Max number of retries: " + this.maxAttempts + ", reached without success. Giving up on operation.");
    }

    int getNumberOfRetries() {
        return this.attemptCounter;
    }

    public static interface Operation<T> {
        public T execute() throws Exception;
    }
}

