/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref;

import java.util.Date;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref.RepresentMemberConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref.UniRefDBConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref.UniRefMemberConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniref.AvroUniRef;

public class UniRefConverter
implements Converter<UniRefEntry, AvroUniRef> {
    private final DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();
    private final UniRefDBConverter dbConverter = new UniRefDBConverter();
    private final UniRefMemberConverter memberConverter = new UniRefMemberConverter();
    private final RepresentMemberConverter repMemberConverter = new RepresentMemberConverter();

    @Override
    public AvroUniRef toAvro(UniRefEntry u) {
        AvroUniRef.Builder builder = AvroUniRef.newBuilder();
        builder.setUpdated(u.getUpdate().getTime()).setUnirefId(u.getUniRefEntryId().getValue()).setName(u.getName().getValue()).setUnirefDb(this.dbConverter.toAvro(u.getUniRefDatabase())).setRepresentMember(this.repMemberConverter.toAvro(u.getRepresentativeMember()));
        builder.setMembers(u.getMembers().stream().map(this.memberConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public UniRefEntry fromAvro(AvroUniRef a) {
        UniRefEntry entry = this.factory.buildUniRefEntry();
        entry.setName(this.factory.buildUniRefEntryName(a.getName().toString()));
        entry.setUniRefEntryId(this.factory.buildUniRefEntryId(a.getUnirefId().toString()));
        entry.setUpdate(new Date(a.getUpdated()));
        entry.setUniRefDatabase(this.dbConverter.fromAvro(a.getUnirefDb()));
        entry.setRepresentativeMember((UniRefRepresentativeMember)this.repMemberConverter.fromAvro(a.getRepresentMember()));
        entry.setMembers(a.getMembers().stream().map(this.memberConverter::fromAvro).collect(Collectors.toList()));
        return entry;
    }
}

