/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniparc.Location;
import uk.ac.ebi.kraken.interfaces.uniparc.SequenceFeature;
import uk.ac.ebi.kraken.interfaces.uniparc.SignatureDBType;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroSequenceFeature;

public class SequenceFeatureConverter
implements Converter<SequenceFeature, AvroSequenceFeature> {
    private final DefaultUniParcFactory factory = DefaultUniParcFactory.getInstance();

    @Override
    public AvroSequenceFeature toAvro(SequenceFeature u) {
        AvroSequenceFeature.Builder builder = AvroSequenceFeature.newBuilder();
        builder.setDbId(u.getDbId()).setSignatureDBType(u.getSignatureDBType().getName());
        if (u.getDomain() != null) {
            builder.setDomainId(u.getDomain().getId()).setDomainName(u.getDomain().getName());
        }
        builder.setLocations(u.getLocations().stream().map(this::locationToAvro).collect(Collectors.toList()));
        return builder.build();
    }

    private String locationToAvro(Location location) {
        return location.getStart() + "-" + location.getEnd();
    }

    private Location locationFromAvro(String loc) {
        int start;
        String[] result = loc.split("-");
        int end = start = Integer.parseInt(result[0]);
        if (result.length == 2) {
            end = Integer.parseInt(result[1]);
        }
        return this.factory.buildLocation(start, end);
    }

    @Override
    public SequenceFeature fromAvro(AvroSequenceFeature a) {
        SequenceFeature seqFeature = this.factory.buildSequenceFeature();
        seqFeature.setDbId(a.getDbId().toString());
        seqFeature.setSignatureDBType(SignatureDBType.getType(a.getSignatureDBType().toString()));
        if (a.getDomainName() != null || a.getDomainId() != null) {
            String domainName = a.getDomainName() == null ? null : a.getDomainName().toString();
            String domainId = a.getDomainId() == null ? null : a.getDomainId().toString();
            seqFeature.setDomain(this.factory.buildDomain(domainName, domainId));
        }
        seqFeature.setLocations(a.getLocations().stream().map(val -> val.toString()).map(this::locationFromAvro).collect(Collectors.toList()));
        return seqFeature;
    }
}

