/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.PubXref;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.PubXrefType;

public class CitationXrefConverter
implements Converter<CitationXrefs, List<PubXref>> {
    private static DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public List<PubXref> toAvro(CitationXrefs u) {
        ArrayList<PubXref> xrefs = new ArrayList<PubXref>();
        if (u.hasPubmedId()) {
            xrefs.add(this.createPubXref(PubXrefType.PUBMED, u.getPubmedId().getValue()));
        }
        if (u.hasDOI()) {
            xrefs.add(this.createPubXref(PubXrefType.DOI, u.getDOI().getValue()));
        }
        if (u.hasAgricolaId()) {
            xrefs.add(this.createPubXref(PubXrefType.AGRICOLA, u.getAgricolaId().getValue()));
        }
        return xrefs;
    }

    private PubXref createPubXref(PubXrefType type, String id) {
        PubXref.Builder builder = PubXref.newBuilder();
        builder.setType(type);
        builder.setValue(id);
        return builder.build();
    }

    @Override
    public CitationXrefs fromAvro(List<PubXref> a) {
        CitationXrefs xrefs = factory.buildCitationXrefs();
        for (PubXref px : a) {
            if (px.getType() == PubXrefType.PUBMED) {
                xrefs.setPubMedId(px.getValue().toString());
                continue;
            }
            if (px.getType() == PubXrefType.DOI) {
                xrefs.setDOI(px.getValue().toString());
                continue;
            }
            if (px.getType() != PubXrefType.AGRICOLA) continue;
            xrefs.setAgricolaId(px.getValue().toString());
        }
        return xrefs;
    }
}

