/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GeneNameType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GnCoordinateType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GnEntry;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate.GeneAvroXmlConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate.GnCoordinateAvroXmlConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate.ProteinAvroXmlConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnCoordinate;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnEntryAvroObject;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnGeneName;

public class GnEntryAvroXmlConverter
implements Converter<GnEntry, GnEntryAvroObject> {
    private final ProteinAvroXmlConverter proteinConverter = new ProteinAvroXmlConverter();
    private final GeneAvroXmlConverter geneConverter = new GeneAvroXmlConverter();
    private final GnCoordinateAvroXmlConverter coordinateConverter = new GnCoordinateAvroXmlConverter();

    @Override
    public GnEntryAvroObject toAvro(GnEntry u) {
        GnEntryAvroObject.Builder entryBuilder = GnEntryAvroObject.newBuilder();
        entryBuilder.setAccession(u.getAccession());
        if (u.getName() != null) {
            entryBuilder.setName(u.getName());
        }
        entryBuilder.setTaxId(u.getTaxid());
        entryBuilder.setSequence(u.getSequence());
        if (u.getProtein() != null) {
            entryBuilder.setProtein(this.proteinConverter.toAvro(u.getProtein()));
        }
        if (u.getGene() != null && !u.getGene().isEmpty()) {
            entryBuilder.setGene(u.getGene().stream().map(val -> this.geneConverter.toAvro((GeneNameType)val)).collect(Collectors.toList()));
        }
        if (u.getGnCoordinate() != null && !u.getGnCoordinate().isEmpty()) {
            entryBuilder.setCoordinates(u.getGnCoordinate().stream().map(val -> this.coordinateConverter.toAvro((GnCoordinateType)val)).filter(val -> val != null).collect(Collectors.toList()));
        }
        return entryBuilder.build();
    }

    @Override
    public GnEntry fromAvro(GnEntryAvroObject a) {
        GnEntry entry = new GnEntry();
        entry.setAccession(a.getAccession().toString());
        if (a.getName() != null) {
            entry.setName(a.getName().toString());
        }
        entry.setTaxid(a.getTaxId());
        entry.setSequence(a.getSequence().toString());
        if (a.getProtein() != null) {
            entry.setProtein(this.proteinConverter.fromAvro(a.getProtein()));
        }
        if (a.getGene() != null && !a.getGene().isEmpty()) {
            a.getGene().stream().map(val -> this.geneConverter.fromAvro((GnGeneName)((Object)val))).forEach(val -> entry.getGene().add((GeneNameType)val));
        }
        if (a.getCoordinates() != null && !a.getCoordinates().isEmpty()) {
            a.getCoordinates().stream().map(val -> this.coordinateConverter.fromAvro((GnCoordinate)((Object)val))).forEach(val -> entry.getGnCoordinate().add((GnCoordinateType)val));
        }
        return entry;
    }
}

