/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.math.BigInteger;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.LocationType;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.PositionType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroLocation;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroPosition;

public class LocationConverter
implements Converter<LocationType, AvroLocation> {
    private final PositionConverter positionConverter = new PositionConverter();

    @Override
    public AvroLocation toAvro(LocationType lType) {
        AvroLocation.Builder builder = AvroLocation.newBuilder();
        if (lType.getBegin() != null) {
            builder.setBegin(this.positionConverter.toAvro(lType.getBegin()));
        }
        if (lType.getEnd() != null) {
            builder.setEnd(this.positionConverter.toAvro(lType.getEnd()));
        }
        if (lType.getPosition() != null) {
            builder.setPosition(this.positionConverter.toAvro(lType.getPosition()));
        }
        return builder.build();
    }

    @Override
    public LocationType fromAvro(AvroLocation avro) {
        LocationType location = new LocationType();
        if (avro.getBegin() != null) {
            location.setBegin(this.positionConverter.fromAvro(avro.getBegin()));
        }
        if (avro.getEnd() != null) {
            location.setEnd(this.positionConverter.fromAvro(avro.getEnd()));
        }
        if (avro.getPosition() != null) {
            location.setPosition(this.positionConverter.fromAvro(avro.getPosition()));
        }
        return location;
    }

    private static class PositionConverter
    implements Converter<PositionType, AvroPosition> {
        private PositionConverter() {
        }

        @Override
        public AvroPosition toAvro(PositionType u) {
            AvroPosition.Builder builder = AvroPosition.newBuilder();
            if (u.getPosition() != null) {
                builder.setPosition(u.getPosition().intValue());
            }
            if (u.getStatus() != null && !u.getStatus().equals("certain")) {
                builder.setStatus(u.getStatus());
            }
            return builder.build();
        }

        @Override
        public PositionType fromAvro(AvroPosition avro) {
            PositionType pType = new PositionType();
            if (avro.getStatus() != null) {
                pType.setStatus(avro.getStatus().toString());
            }
            if (avro.getPosition() != null) {
                BigInteger bi = BigInteger.valueOf(avro.getPosition().intValue());
                pType.setPosition(bi);
            }
            return pType;
        }
    }
}

