/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseAcronym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Disease;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class DiseaseCommentConverter
extends AbstractCommentConverter<DiseaseCommentStructured> {
    @Override
    protected Object convertToAvro(DiseaseCommentStructured comment) {
        DiseaseNote note;
        Disease disease = this.toAvro(comment.getDisease());
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            disease.setMolecule(comment.getMolecule());
        }
        if ((note = comment.getNote()) != null) {
            disease.setNote(note.getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        return disease;
    }

    @Override
    protected DiseaseCommentStructured convertFromAvro(CommentType type, Object avroObj) {
        DiseaseCommentStructured comment = (DiseaseCommentStructured)factory.buildComment(type);
        Disease disease = (Disease)((Object)avroObj);
        if (disease.getMolecule() != null) {
            comment.setMolecule(disease.getMolecule().toString());
        }
        if (disease.getNote() != null) {
            DiseaseNote note = factory.buildDiseaseNote();
            List<EvidencedValue> evValues = disease.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            note.setTexts(evValues);
            comment.setNote(note);
        }
        comment.setDisease(this.fromAvro(disease));
        return comment;
    }

    @Override
    private Disease toAvro(uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease u) {
        Disease.Builder builder = Disease.newBuilder();
        builder.setName(u.getDiseaseId().getValue());
        builder.setAcronym(u.getAcronym().getValue());
        builder.setMim(u.getReference().getDiseaseReferenceId().getValue());
        builder.setDescription(ConverterHelper.convert(u.getDescription().getValue(), u.getDescription().getEvidenceIds()));
        return builder.build();
    }

    @Override
    private uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease fromAvro(Disease a) {
        uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease disease = factory.buildDisease();
        DiseaseId id = factory.buildDiseaseId();
        id.setValue(a.getName().toString());
        disease.setDiseaseId(id);
        DiseaseAcronym dc = factory.buildDiseaseAcronym();
        dc.setValue(a.getAcronym().toString());
        disease.setDiseaseAcronym(dc);
        DiseaseDescription dd = factory.buildDiseaseDescription();
        dd.setValue(a.getDescription().getKey().toString());
        dd.setEvidenceIds(evidenceConverter.fromAvro(a.getDescription().getEvidence()));
        disease.setDiseaseDescription(dd);
        DiseaseReference dr = factory.buildDiseaseReference();
        dr.setDiseaseReferenceType(DiseaseReferenceType.MIM);
        DiseaseReferenceId drId = factory.buildDiseaseReferenceId();
        drId.setValue(a.getMim().toString());
        dr.setDiseaseReferenceId(drId);
        disease.setDiseaseReference(dr);
        return disease;
    }
}

