/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.CofactorItemConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Cofactor;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.CofactorItem;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class CofactorCommentConverter
extends AbstractCommentConverter<CofactorCommentStructured> {
    private final CofactorItemConverter cofactorItemConverter = new CofactorItemConverter();

    @Override
    protected Object convertToAvro(CofactorCommentStructured comment) {
        Cofactor.Builder builder = Cofactor.newBuilder();
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            builder.setMolecule(comment.getMolecule());
        }
        if (comment.getNote() != null && comment.getNote().getTexts() != null) {
            builder.setNote(comment.getNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        if (comment.getCofactors() != null && !comment.getCofactors().isEmpty()) {
            builder.setCofactors(comment.getCofactors().stream().map(v -> this.cofactorItemConverter.toAvro((uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor)v)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    protected CofactorCommentStructured convertFromAvro(CommentType type, Object avroObj) {
        CofactorCommentStructured comment = (CofactorCommentStructured)factory.buildComment(type);
        Cofactor cofactor = (Cofactor)((Object)avroObj);
        if (cofactor.getMolecule() != null) {
            comment.setMolecule(cofactor.getMolecule().toString());
        }
        if (cofactor.getNote() != null) {
            CofactorNote note = factory.buildCofactorNote();
            List<EvidencedValue> evValues = cofactor.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            note.setTexts(evValues);
            comment.setNote(note);
        }
        if (cofactor.getCofactors() != null && !cofactor.getCofactors().isEmpty()) {
            comment.setCofactors(cofactor.getCofactors().stream().map(v -> this.cofactorItemConverter.fromAvro((CofactorItem)((Object)v))).collect(Collectors.toList()));
        }
        return comment;
    }
}

