/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.text.NumberFormat;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class BPCPMaximumVelocityConverter
implements Converter<MaximumVelocity, EvidencedString> {
    private final ThreadLocal<NumberFormat> numberFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat get() {
            return (NumberFormat)super.get();
        }

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getNumberInstance();
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(NumberFormat value) {
            super.set(value);
        }
    };
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public EvidencedString toAvro(MaximumVelocity u) {
        String val = this.build(u);
        return ConverterHelper.convert(val, u.getEvidenceIds());
    }

    @Override
    public MaximumVelocity fromAvro(EvidencedString vs) {
        MaximumVelocity mv = this.build(vs.getKey().toString());
        mv.setEvidenceIds(this.evidenceConverter.fromAvro(vs.getEvidence()));
        return mv;
    }

    private String build(MaximumVelocity mv) {
        StringBuilder vm = new StringBuilder();
        String val = this.numberFormatter.get().format(mv.getVelocity());
        String val2 = "" + mv.getVelocity();
        if (val.contains(".")) {
            val = val2;
        }
        val = val.replace(",", "");
        vm.append(val);
        vm.append(" ");
        vm.append(mv.getMaxVelocityUnit().getValue());
        vm.append(" ");
        vm.append(mv.getEnzyme().getValue());
        return vm.toString();
    }

    private MaximumVelocity build(String vmaxStr) {
        MaximumVelocity mv = DefaultCommentFactory.getInstance().buildMaximumVelocity();
        int index = vmaxStr.indexOf(32);
        String val = vmaxStr.substring(0, index).trim();
        vmaxStr = vmaxStr.substring(index + 1).trim();
        index = vmaxStr.indexOf(32);
        String unit = vmaxStr.substring(0, index).trim();
        vmaxStr = vmaxStr.substring(index + 1).trim();
        double value = Double.parseDouble(val);
        mv.setMaxVelocityUnit(DefaultCommentFactory.getInstance().buildMaxVelocityUnit(unit));
        mv.setVelocity((float)value);
        mv.setEnzyme(DefaultCommentFactory.getInstance().buildEnzyme(vmaxStr));
        return mv;
    }
}

