/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidencedStringConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Isoform;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.SequenceType;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class APIsoformConverter
implements Converter<AlternativeProductsIsoform, Isoform> {
    private final EvidencedStringConverter evidencedStringConverter = new EvidencedStringConverter();
    private final CommentFactory factory = DefaultCommentFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Isoform toAvro(AlternativeProductsIsoform isoform) {
        Isoform.Builder builder = Isoform.newBuilder();
        ArrayList<CharSequence> isoIds = new ArrayList<CharSequence>();
        for (IsoformId id : isoform.getIds()) {
            isoIds.add(id.getValue());
        }
        builder.setId(isoIds);
        builder.setName(ConverterHelper.convert(isoform.getName().getValue(), isoform.getName().getEvidenceIds()));
        if (isoform.getNote() != null && !isoform.getNote().getTexts().isEmpty()) {
            builder.setNote(isoform.getNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        builder.setSequenceType(this.from(isoform.getIsoformSequenceStatus()));
        ArrayList<CharSequence> seqIds = new ArrayList<CharSequence>();
        for (IsoformSequenceId seqId : isoform.getSequenceIds()) {
            seqIds.add(seqId.getValue());
        }
        builder.setSequenceId(seqIds);
        builder.setSynonyms(isoform.getSynonyms().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public AlternativeProductsIsoform fromAvro(Isoform name) {
        AlternativeProductsIsoform isoform = this.factory.buildAlternativeProductsIsoform();
        ArrayList<IsoformId> isoIds = new ArrayList<IsoformId>();
        for (CharSequence cs : name.getId()) {
            isoIds.add(this.factory.buildIsoformId(cs.toString()));
        }
        isoform.setIds(isoIds);
        IsoformName isoName = this.factory.buildIsoformName(name.getName().getKey().toString());
        isoName.setEvidenceIds(this.evidenceConverter.fromAvro(name.getName().getEvidence()));
        isoform.setName(isoName);
        if (name.getNote() != null) {
            IsoformNote note = this.factory.buildIsoformNote();
            List<EvidencedValue> evValues = name.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            note.setTexts(evValues);
            isoform.setNote(note);
        }
        isoform.setIsoformSequenceStatus(this.to(name.getSequenceType()));
        ArrayList<IsoformSequenceId> seqIds = new ArrayList<IsoformSequenceId>();
        for (CharSequence cs : name.getSequenceId()) {
            seqIds.add(this.factory.buildIsoformSequenceId(cs.toString()));
        }
        isoform.setSequenceIds(seqIds);
        isoform.setSynonyms(name.getSynonyms().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).map(v1 -> {
            IsoformSynonym syn = this.factory.buildIsoformSynonym();
            syn.setValue(v1.getValue());
            syn.setEvidenceIds(v1.getEvidenceIds());
            return syn;
        }).collect(Collectors.toList()));
        return isoform;
    }

    private SequenceType from(IsoformSequenceStatus status) {
        switch (status) {
            case DISPLAYED: {
                return SequenceType.Displayed;
            }
            case EXTERNAL: {
                return SequenceType.External;
            }
            case NOT_DESCRIBED: {
                return SequenceType.Not_described;
            }
            case DESCRIBED: {
                return SequenceType.Described;
            }
        }
        return SequenceType.Displayed;
    }

    private IsoformSequenceStatus to(SequenceType status) {
        switch (status) {
            case Displayed: {
                return IsoformSequenceStatus.DISPLAYED;
            }
            case External: {
                return IsoformSequenceStatus.EXTERNAL;
            }
            case Not_described: {
                return IsoformSequenceStatus.NOT_DESCRIBED;
            }
            case Described: {
                return IsoformSequenceStatus.DESCRIBED;
            }
        }
        return IsoformSequenceStatus.DISPLAYED;
    }
}

