/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;
import uk.ac.ebi.uniprot.services.data.serializer.model.gn.GeneName;
import uk.ac.ebi.uniprot.services.data.serializer.model.gn.Genes;
import uk.ac.ebi.uniprot.services.data.serializer.model.gn.GnNameType;

public class GeneConverter
implements Converter<Gene, Genes> {
    private final DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Genes toAvro(Gene gene) {
        GeneName.Builder nameBuilder;
        Genes.Builder builder = Genes.newBuilder();
        ArrayList<GeneName> geneNames = new ArrayList<GeneName>();
        if (gene.getGeneName() != null && !gene.getGeneName().getValue().isEmpty()) {
            nameBuilder = GeneName.newBuilder();
            nameBuilder.setType(GnNameType.GENAME);
            ArrayList<EvidencedString> names = new ArrayList<EvidencedString>();
            names.add(ConverterHelper.convert(gene.getGeneName().getValue(), gene.getGeneName().getEvidenceIds()));
            nameBuilder.setName(names);
            geneNames.add(nameBuilder.build());
        }
        if (!gene.getGeneNameSynonyms().isEmpty()) {
            nameBuilder = GeneName.newBuilder();
            nameBuilder.setType(GnNameType.SYNNAME);
            nameBuilder.setName(gene.getGeneNameSynonyms().stream().map(syn -> ConverterHelper.convert(syn.getValue(), syn.getEvidenceIds())).collect(Collectors.toList()));
            geneNames.add(nameBuilder.build());
        }
        if (!gene.getORFNames().isEmpty()) {
            nameBuilder = GeneName.newBuilder();
            nameBuilder.setType(GnNameType.ORFNAME);
            nameBuilder.setName(gene.getORFNames().stream().map(syn -> ConverterHelper.convert(syn.getValue(), syn.getEvidenceIds())).collect(Collectors.toList()));
            geneNames.add(nameBuilder.build());
        }
        if (!gene.getOrderedLocusNames().isEmpty()) {
            nameBuilder = GeneName.newBuilder();
            nameBuilder.setType(GnNameType.OLNAME);
            nameBuilder.setName(gene.getOrderedLocusNames().stream().map(syn -> ConverterHelper.convert(syn.getValue(), syn.getEvidenceIds())).collect(Collectors.toList()));
            geneNames.add(nameBuilder.build());
        }
        builder.setGeneNames(geneNames);
        return builder.build();
    }

    @Override
    public Gene fromAvro(Genes a) {
        Gene gene = this.factory.buildGene();
        for (GeneName geneName : a.getGeneNames()) {
            if (geneName.getType() == GnNameType.GENAME) {
                uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName gname = this.factory.buildGeneName();
                gname.setValue(geneName.getName().get(0).getKey().toString());
                gname.setEvidenceIds(this.evidenceConverter.fromAvro(geneName.getName().get(0).getEvidence()));
                gene.setGeneName(gname);
                continue;
            }
            if (geneName.getType() == GnNameType.SYNNAME) {
                gene.setGeneNameSynonyms(geneName.getName().stream().map(val -> {
                    GeneNameSynonym syn = this.factory.buildGeneNameSynonym();
                    syn.setValue(val.getKey().toString());
                    syn.setEvidenceIds(this.evidenceConverter.fromAvro(val.getEvidence()));
                    return syn;
                }).collect(Collectors.toList()));
                continue;
            }
            if (geneName.getType() == GnNameType.ORFNAME) {
                gene.setORFNames(geneName.getName().stream().map(val -> {
                    ORFName orf = this.factory.buildORFName();
                    orf.setValue(val.getKey().toString());
                    orf.setEvidenceIds(this.evidenceConverter.fromAvro(val.getEvidence()));
                    return orf;
                }).collect(Collectors.toList()));
                continue;
            }
            if (geneName.getType() != GnNameType.OLNAME) continue;
            gene.setOrderedLocusNames(geneName.getName().stream().map(val -> {
                OrderedLocusName oln = this.factory.buildOrderedLocusName();
                oln.setValue(val.getKey().toString());
                oln.setEvidenceIds(this.evidenceConverter.fromAvro(val.getEvidence()));
                return oln;
            }).collect(Collectors.toList()));
        }
        return gene;
    }
}

