/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalSection;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.AvEvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.CitationConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.DBCrossReferenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.DescriptionConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EntryInfoConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.FeatureConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.GeneConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.GenericCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.InternalSectionConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.KeywordConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.OrganismConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.SequenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ac.EntryInfo;
import uk.ac.ebi.uniprot.services.data.serializer.model.dr.Xref;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;
import uk.ac.ebi.uniprot.services.data.serializer.model.gn.Genes;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.Organism;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.Publication;

public class EntryConverter
implements Converter<UniProtEntry, EntryObject> {
    private final EntryInfoConverter entryInfoConverter = new EntryInfoConverter();
    private final CitationConverter citationConverter = new CitationConverter();
    private final GenericCommentConverter<Comment> commentConverter = new GenericCommentConverter();
    private final DBCrossReferenceConverter dbXRefConverter = new DBCrossReferenceConverter();
    private final DescriptionConverter descriptionConverter = new DescriptionConverter();
    private final FeatureConverter featureConverter = new FeatureConverter();
    private final GeneConverter geneConverter = new GeneConverter();
    private final KeywordConverter keywordConverter = new KeywordConverter();
    private final OrganismConverter organismConverter = new OrganismConverter();
    private final SequenceConverter sequenceConverter = new SequenceConverter();
    private final InternalSectionConverter internalSectionConverter = new InternalSectionConverter();
    private final AvEvidenceConverter avEvidenceConverter = new AvEvidenceConverter();
    private final UniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public EntryObject toAvro(UniProtEntry entry) {
        EntryObject.Builder builder = EntryObject.newBuilder();
        builder.setEntryInfo(this.convertEntryInfoToAvro(entry));
        builder.setOrganism(this.convertOrganismToAvro(entry));
        builder.setSequence(this.sequenceConverter.toAvro(entry.getSequence()));
        builder.setProtein(this.descriptionConverter.toAvro(entry.getProteinDescription()));
        builder.setAvEvidence(this.avEvidenceConverter.toAvro(entry.getEvidences()));
        builder.setComment(entry.getComments().stream().map(cc -> this.commentConverter.toAvro((Comment)cc)).collect(Collectors.toList()));
        builder.setDbReference(entry.getDatabaseCrossReferences().stream().map(xref -> this.dbXRefConverter.toAvro((DatabaseCrossReference)xref)).collect(Collectors.toList()));
        builder.setFeature(entry.getFeatures().stream().map(ft -> this.featureConverter.toAvro((Feature)ft)).collect(Collectors.toList()));
        builder.setGene(entry.getGenes().stream().map(gn -> this.geneConverter.toAvro((Gene)gn)).collect(Collectors.toList()));
        builder.setKeyword(entry.getKeywords().stream().map(kw -> this.keywordConverter.toAvro((Keyword)kw)).collect(Collectors.toList()));
        builder.setReference(entry.getCitationsNew().stream().map(ref -> this.citationConverter.toAvro((Citation)ref)).collect(Collectors.toList()));
        if (this.isValidInternalSection(entry.getInternalSection())) {
            builder.setInternalSection(this.internalSectionConverter.toAvro(entry.getInternalSection()));
        }
        return builder.build();
    }

    private boolean isValidInternalSection(InternalSection is) {
        return is != null && (!is.getInternalLines().isEmpty() || !is.getSourceLines().isEmpty());
    }

    @Override
    public UniProtEntry fromAvro(EntryObject avroEntry) {
        UniProtEntry entry = this.factory.buildEntry();
        this.updateEntryInfo(entry, avroEntry.getEntryInfo());
        entry.setEvidences(this.avEvidenceConverter.fromAvro(avroEntry.getAvEvidence()));
        this.updateEntryOrganism(entry, avroEntry.getOrganism());
        entry.setSequence(this.sequenceConverter.fromAvro(avroEntry.getSequence()));
        entry.setProteinDescription(this.descriptionConverter.fromAvro(avroEntry.getProtein()));
        entry.setComments(avroEntry.getComment().stream().map(cc -> this.commentConverter.fromAvro((uk.ac.ebi.uniprot.services.data.serializer.model.cc.Comment)((Object)cc))).collect(Collectors.toList()));
        entry.setDatabaseCrossReferences(avroEntry.getDbReference().stream().map(xref -> this.dbXRefConverter.fromAvro((Xref)((Object)xref))).filter(mapped -> mapped != null).collect(Collectors.toList()));
        entry.setFeatures(avroEntry.getFeature().stream().map(ft -> this.featureConverter.fromAvro((CharSequence)ft)).collect(Collectors.toList()));
        entry.setGenes(avroEntry.getGene().stream().map(gn -> this.geneConverter.fromAvro((Genes)((Object)gn))).collect(Collectors.toList()));
        entry.setKeywords(avroEntry.getKeyword().stream().map(kw -> this.keywordConverter.fromAvro((EvidencedString)((Object)kw))).collect(Collectors.toList()));
        entry.setCitationsNew(avroEntry.getReference().stream().map(ref -> this.citationConverter.fromAvro((Publication)((Object)ref))).collect(Collectors.toList()));
        if (avroEntry.getInternalSection() != null) {
            entry.setInternalSection(this.internalSectionConverter.fromAvro(avroEntry.getInternalSection()));
        }
        return entry;
    }

    private EntryInfo convertEntryInfoToAvro(UniProtEntry u) {
        EntryInfoConverter.UniProtEntryInfo uniprotEntryInfo = new EntryInfoConverter.UniProtEntryInfo(u.getType(), u.getPrimaryUniProtAccession(), u.getUniProtId(), u.getSecondaryUniProtAccessions(), u.getProteinExistence(), u.getEntryAudit());
        return this.entryInfoConverter.toAvro(uniprotEntryInfo);
    }

    private void updateEntryInfo(UniProtEntry entry, EntryInfo avroEntryInfo) {
        EntryInfoConverter.UniProtEntryInfo entryInfo = this.entryInfoConverter.fromAvro(avroEntryInfo);
        entry.setType(entryInfo.getType());
        entry.setPrimaryUniProtAccession(entryInfo.getPrimaryUniProtAccession());
        entry.setUniProtId(entryInfo.getUniProtId());
        entry.setSecondaryUniProtAccessions(entryInfo.getSecondaryUniProtAccessions());
        entry.setProteinExistence(entryInfo.getProteinExistence());
        entry.setEntryAudit(entryInfo.getEntryAudit());
    }

    private Organism convertOrganismToAvro(UniProtEntry entry) {
        OrganismConverter.UniProtOrganismInfo organismInfo = new OrganismConverter.UniProtOrganismInfo(entry.getOrganism(), entry.getTaxonomy(), entry.getNcbiTaxonomyIds(), entry.getOrganismHosts(), entry.getOrganelles());
        return this.organismConverter.toAvro(organismInfo);
    }

    private void updateEntryOrganism(UniProtEntry entry, Organism avroOrganism) {
        OrganismConverter.UniProtOrganismInfo organismInfo = this.organismConverter.fromAvro(avroOrganism);
        entry.setOrganism(organismInfo.getOrganism());
        entry.setTaxonomy(organismInfo.getTaxonomy());
        entry.setNcbiTaxonomyIds(organismInfo.getNcbiTaxonomyIds());
        entry.setOrganismHosts(organismInfo.getOrganismHosts());
        entry.setOrganelles(organismInfo.getOrganelles());
    }
}

