/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.Name;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class DescriptionNameConverter
implements Converter<uk.ac.ebi.kraken.interfaces.uniprot.description.Name, Name> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Name toAvro(uk.ac.ebi.kraken.interfaces.uniprot.description.Name name) {
        Name.Builder builder = Name.newBuilder();
        List<EvidencedString> fullNames = this.convertToAvroField(name.getFieldsByType(FieldType.FULL));
        if (!fullNames.isEmpty()) {
            builder.setFullName(fullNames.get(0));
        }
        builder.setShortNames(this.convertToAvroField(name.getFieldsByType(FieldType.SHORT)));
        builder.setEcNumber(this.convertToAvroField(name.getFieldsByType(FieldType.EC)));
        builder.setAllergen(this.convertToAvroField(name.getFieldsByType(FieldType.ALLERGEN)));
        builder.setBiotech(this.convertToAvroField(name.getFieldsByType(FieldType.BIOTECH)));
        builder.setCdAntigen(this.convertToAvroField(name.getFieldsByType(FieldType.CD_ANTIGEN)));
        builder.setInn(this.convertToAvroField(name.getFieldsByType(FieldType.INN)));
        return builder.build();
    }

    private List<EvidencedString> convertToAvroField(List<Field> fields) {
        return fields.stream().map(field -> ConverterHelper.convert(field.getValue(), field.getEvidenceIds())).collect(Collectors.toList());
    }

    private Field createField(FieldType type, EvidencedString avroStr) {
        Field field = factory.buildField();
        field.setType(type);
        field.setEvidenceIds(this.evidenceConverter.fromAvro(avroStr.getEvidence()));
        field.setValue(avroStr.getKey().toString());
        return field;
    }

    @Override
    public uk.ac.ebi.kraken.interfaces.uniprot.description.Name fromAvro(Name avroName) {
        uk.ac.ebi.kraken.interfaces.uniprot.description.Name name = factory.buildName();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (avroName.getFullName() != null) {
            fields.add(this.createField(FieldType.FULL, avroName.getFullName()));
        }
        fields.addAll(avroName.getShortNames().stream().map(af -> this.createField(FieldType.SHORT, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        fields.addAll(avroName.getEcNumber().stream().map(af -> this.createField(FieldType.EC, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        fields.addAll(avroName.getAllergen().stream().map(af -> this.createField(FieldType.ALLERGEN, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        fields.addAll(avroName.getInn().stream().map(af -> this.createField(FieldType.INN, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        fields.addAll(avroName.getBiotech().stream().map(af -> this.createField(FieldType.BIOTECH, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        fields.addAll(avroName.getCdAntigen().stream().map(af -> this.createField(FieldType.CD_ANTIGEN, (EvidencedString)((Object)af))).collect(Collectors.toList()));
        name.setFields(fields);
        return name;
    }
}

