/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.AvEvidence;

public class AvEvidenceConverter
implements Converter<List<Evidence>, List<AvEvidence>> {
    @Override
    public List<AvEvidence> toAvro(List<Evidence> u) {
        return u.stream().map(ev -> this.toAvro((Evidence)ev)).collect(Collectors.toList());
    }

    @Override
    AvEvidence toAvro(Evidence u) {
        AvEvidence.Builder builder = AvEvidence.newBuilder();
        builder.setEvidence(u.getEvidenceId().getValue());
        builder.setType(u.getType().getValue());
        return builder.build();
    }

    @Override
    public List<Evidence> fromAvro(List<AvEvidence> a) {
        if (a != null && !a.isEmpty()) {
            return a.stream().map(av -> this.fromAvro((AvEvidence)((Object)av))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    Evidence fromAvro(AvEvidence a) {
        EvidenceId evId = DefaultUniProtFactory.getInstance().buildEvidenceId(a.getEvidence().toString());
        return EvidenceHelper.convert(evId);
    }
}

