/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.impl.AbstractQuery;

class RangeQuery
extends AbstractQuery {
    private String low;
    private boolean i_low;
    private String high;
    private boolean i_high;
    private String field;

    private RangeQuery() {
    }

    public RangeQuery(String field, String lower, String higher) {
        this(field, lower, false, higher, false);
    }

    public RangeQuery(String field, String lower, boolean includeLow, String higher, boolean includeHigh) {
        this.field = field;
        this.low = lower;
        this.i_low = includeLow;
        this.high = higher;
        this.i_high = includeHigh;
    }

    @Override
    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field).append(" : ");
        sb.append(this.i_low ? "[" : "{");
        sb.append(this.low).append(" TO ");
        sb.append(this.high);
        sb.append(this.i_high ? "]" : "}");
        return sb.toString();
    }

    @Override
    public Query not() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.high == null ? 0 : this.high.hashCode());
        result = 31 * result + (this.i_high ? 1231 : 1237);
        result = 31 * result + (this.i_low ? 1231 : 1237);
        result = 31 * result + (this.low == null ? 0 : this.low.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeQuery other = (RangeQuery)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.high == null ? other.high != null : !this.high.equals(other.high)) {
            return false;
        }
        if (this.i_high != other.i_high) {
            return false;
        }
        if (this.i_low != other.i_low) {
            return false;
        }
        return !(this.low == null ? other.low != null : !this.low.equals(other.low));
    }
}

