/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import java.util.Map;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtField;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtRequest;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class DefaultUniProtRequest
implements UniProtRequest {
    private BasicRequest request;
    private boolean retrieveUniprotEntry;
    private boolean withIsoform = false;
    static final String UNIPROT_ENTRY_RETRIEVAL_FLAG = "";
    static final String RETURN_FIELD = "fl";
    static final String QUERY_FIELD = "q";
    static final String FILTER_QUERY_FIELD = "fq";
    static final String ACCESSION_FIELD = "accession";

    private DefaultUniProtRequest() {
    }

    public DefaultUniProtRequest(BasicRequest basicRequest) {
        this.request = basicRequest;
        this.request.setPrimaryFieldName(UniProtField.Search.accession.name());
    }

    @Override
    public void setFields(UniProtField.Return ... fields) {
        this.request.setFields(fields);
    }

    @Override
    public void setSort(UniProtField.Search field, boolean desc) {
        this.request.setSort(field, desc);
    }

    @Override
    public void setResultOffset(long start) {
        this.request.setResultOffset(start);
    }

    @Override
    public long getResultOffset() {
        return this.request.getResultOffset();
    }

    @Override
    public void setResultCardinality(int number) {
        this.request.setResultCardinality(number);
    }

    @Override
    public int getResultCardinality() {
        return this.request.getResultCardinality();
    }

    @Override
    public void setQuery(Query condition) {
        this.request.setQuery(condition);
    }

    @Override
    public Query getQuery() {
        return this.request.getQuery();
    }

    @Override
    public Request pageRequest(long start) {
        BasicRequest basicRequest = this.request.pageRequest(start);
        DefaultUniProtRequest defaultUniProtRequest = new DefaultUniProtRequest(basicRequest);
        defaultUniProtRequest.retrieveUniprotEntry = this.retrieveUniprotEntry;
        defaultUniProtRequest.withIsoform = this.withIsoform;
        return defaultUniProtRequest;
    }

    @Override
    public Request pageRequest(String cursorMark) {
        BasicRequest basicRequest = this.request.pageRequest(cursorMark);
        DefaultUniProtRequest defaultUniProtRequest = new DefaultUniProtRequest(basicRequest);
        defaultUniProtRequest.retrieveUniprotEntry = this.retrieveUniprotEntry;
        defaultUniProtRequest.withIsoform = this.withIsoform;
        return defaultUniProtRequest;
    }

    @Override
    public void setCursorMark(String cursormark) {
        this.request.setCursorMark(cursormark);
    }

    @Override
    public String getCursorMark() {
        return this.request.getCursorMark();
    }

    @Override
    public void setRetrieveUniProtEntry(boolean retrieve) {
        this.retrieveUniprotEntry = retrieve;
    }

    @Override
    public void setWithIsoform(boolean withIsoform) {
        this.withIsoform = withIsoform;
    }

    @Override
    public Map<String, String> buildQueryMap() {
        Map<String, String> queryMap = this.request.buildQueryMap();
        if (this.retrieveUniprotEntry) {
            this.addRetrieveEntryFlag(queryMap);
        }
        if (!this.withIsoform && !this.checkIsoformQuery(queryMap.get(QUERY_FIELD))) {
            queryMap.put(FILTER_QUERY_FIELD, UniProtField.Search.is_isoform.name() + ":false");
        }
        return queryMap;
    }

    private boolean checkIsoformQuery(String s) {
        return s.contains(UniProtField.Search.is_isoform.name());
    }

    private void addRetrieveEntryFlag(Map<String, String> queryMap) {
        String returnFields = queryMap.get(RETURN_FIELD);
        if (returnFields == null || returnFields.equals("*")) {
            returnFields = ACCESSION_FIELD;
        }
        queryMap.put(RETURN_FIELD, returnFields);
    }

    public String toString() {
        return "DefaultUniProtRequest{" + this.request.convertFieldsToString() + ", retrieveUniprotEntry=" + this.retrieveUniprotEntry + '}';
    }
}

