/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.CheckStatus;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerFactory;

public class ServiceCheckerMain {
    public static void main(String[] args) {
        Configuration configuration = new Configuration(args);
        System.out.println("Service Check Configuration: " + configuration.toString());
        ServiceCheckerMain.report(ServiceCheckerMain.runChecks(configuration));
    }

    private static Map<Boolean, List<CheckStatus>> runChecks(Configuration configuration) {
        ServiceCheckerFactory factory = new ServiceCheckerFactory(configuration.getServiceUrl());
        Set<ServiceEnum> serviceToCheck = configuration.getServiceToCheck();
        return serviceToCheck.stream().map(factory::createServiceChecker).map(serviceChecker -> ServiceCheckerMain.checkService(serviceChecker, configuration.isFullCheck())).collect(Collectors.partitioningBy(CheckStatus::isSuccess));
    }

    private static void report(Map<Boolean, List<CheckStatus>> collect) {
        System.out.println("========================");
        System.out.println("Service check Report");
        List<CheckStatus> checkStatuses = collect.get(Boolean.FALSE);
        if (checkStatuses == null) {
            System.out.println("Checking All Passed!");
        }
        System.out.println("========================");
    }

    private static CheckStatus checkService(ServiceChecker checker, boolean fullCheck) {
        System.out.println("Start Checking service: " + checker.getServiceEnum().name());
        CheckStatus result = null;
        try {
            result = checker.runCheck(fullCheck);
        }
        catch (Exception e) {
            result = CheckStatus.failed(e);
        }
        System.out.println("Checking is done for: " + checker.getServiceEnum().name());
        return result;
    }

    public static class Configuration {
        @Parameter(names={"-serviceUrl"}, description="The service url the checker run against")
        public String serviceUrl;
        @Parameter(names={"-service"})
        public List<String> servicesToCheck = new ArrayList<String>();
        @Parameter(names={"-briefCheck"}, description="Whether to run the full test suite to check the services.", arity=1)
        private boolean briefCheck = true;

        public Configuration(String[] args) {
            new JCommander((Object)this, args);
        }

        public Set<ServiceEnum> getServiceToCheck() {
            if (this.servicesToCheck.isEmpty()) {
                return Stream.of(ServiceEnum.values()).collect(Collectors.toSet());
            }
            try {
                return this.servicesToCheck.stream().flatMap(s -> Stream.of(s.split(","))).map(o -> o.toString()).map(String::trim).map(ServiceEnum::valueOf).collect(Collectors.toSet());
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("Doesn't recognize the specified services names: " + e.getMessage());
            }
        }

        public String toString() {
            return "serviceUrl='" + this.serviceUrl + "', servicesToCheck=" + Arrays.toString(this.servicesToCheck.toArray()) + ", briefCheck=" + this.briefCheck;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public boolean isFullCheck() {
            return !this.briefCheck;
        }
    }

    public static enum ServiceEnum {
        uniprot,
        uniref,
        uniparc;

    }
}

