/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker;

import uk.ac.ebi.uniprot.dataservice.client.Service;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.CheckStatus;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerMain;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.UtilException;

public interface ServiceChecker<S extends Service> {
    public CheckStatus fullCheck();

    public CheckStatus briefCheck();

    public ServiceCheckerMain.ServiceEnum getServiceEnum();

    public S getService();

    default public CheckStatus runCheck(boolean fullCheck) {
        this.getService().start();
        try {
            CheckStatus checkStatus = fullCheck ? this.fullCheck() : this.briefCheck();
            return checkStatus;
        }
        finally {
            this.getService().stop();
        }
    }

    default public <T> CheckStatus checkService(T query, UtilException.BiConsumer_WithExceptions<S, T> oneCheck) {
        try {
            oneCheck.accept(this.getService(), query);
            return CheckStatus.success();
        }
        catch (Exception e) {
            return CheckStatus.failed(e);
        }
    }

    default public CheckStatus checkService(UtilException.Consumer_WithExceptions<S> oneCheck) {
        try {
            oneCheck.accept(this.getService());
            return CheckStatus.success();
        }
        catch (Exception e) {
            return CheckStatus.failed(e);
        }
    }
}

