/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefBlastService;
import uk.ac.ebi.uniprot.dataservice.client.info.InfoService;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;

class DefaultServiceFactory
implements ServiceFactory {
    private final Provider<UniProtService> uniProtQueryServiceProvider;
    private final Provider<UniParcService> uniParcQueryServiceProvider;
    private final Provider<UniRefService> uniRefQueryServiceProvider;
    private final Provider<UniProtBlastService> uniProtBlastServiceProvider;
    private final Provider<UniParcBlastService> uniParcBlastServiceProvider;
    private final Provider<UniRefBlastService> uniRefBlastServiceProvider;
    private final Provider<InfoService> infoServiceProvider;

    @Inject
    public DefaultServiceFactory(Provider<UniProtService> uniProtQueryServiceProvider, Provider<UniParcService> uniParcQueryServiceProvider, Provider<UniRefService> uniRefQueryServiceProvider, Provider<UniProtBlastService> uniProtBlastServiceProvider, Provider<UniParcBlastService> uniParcBlastServiceProvider, Provider<UniRefBlastService> uniRefBlastServiceProvider, Provider<InfoService> infoServiceProvider) {
        this.uniProtQueryServiceProvider = uniProtQueryServiceProvider;
        this.uniParcQueryServiceProvider = uniParcQueryServiceProvider;
        this.uniRefQueryServiceProvider = uniRefQueryServiceProvider;
        this.uniProtBlastServiceProvider = uniProtBlastServiceProvider;
        this.uniParcBlastServiceProvider = uniParcBlastServiceProvider;
        this.uniRefBlastServiceProvider = uniRefBlastServiceProvider;
        this.infoServiceProvider = infoServiceProvider;
    }

    @Override
    public UniProtService getUniProtQueryService() {
        return (UniProtService)this.uniProtQueryServiceProvider.get();
    }

    @Override
    public UniParcService getUniParcQueryService() {
        return (UniParcService)this.uniParcQueryServiceProvider.get();
    }

    @Override
    public UniRefService getUniRefQueryService() {
        return (UniRefService)this.uniRefQueryServiceProvider.get();
    }

    @Override
    public UniProtBlastService getUniProtBlastService() {
        return (UniProtBlastService)this.uniProtBlastServiceProvider.get();
    }

    @Override
    public UniParcBlastService getUniParcBlastService() {
        return (UniParcBlastService)this.uniParcBlastServiceProvider.get();
    }

    @Override
    public UniRefBlastService getUniRefBlastService() {
        return (UniRefBlastService)this.uniRefBlastServiceProvider.get();
    }

    @Override
    public InfoService getInfoService() {
        return (InfoService)this.infoServiceProvider.get();
    }
}

