/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.Map;
import uk.ac.ebi.uniprot.dataservice.client.ClientConfigurator;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastGuiceModule;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicRequest;
import uk.ac.ebi.uniprot.dataservice.client.impl.ClientConfiguratorImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultRequestImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.info.impl.InfoServiceGuiceModule;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.JapiUniParcGuiceModule;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.JapiUniProtGuiceModule;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.JapiUniRefGuiceModule;
import uk.ac.ebi.uniprot.dataservice.query.impl.QueryGuiceModule;

public class ClientGuiceModule
extends AbstractModule {
    private final ClientConfiguratorImpl clientConfigurator = new ClientConfiguratorImpl();

    public ClientGuiceModule(Map<String, String> clientConfigurator) {
        this.clientConfigurator.overrideWith(clientConfigurator);
    }

    public ClientGuiceModule() {
    }

    protected void configure() {
        this.bind(ClientConfigurator.class).toInstance((Object)this.clientConfigurator);
        this.bind(HttpRequestConfig.class).toInstance((Object)this.clientConfigurator.getHttpConfig());
        this.bind(ServiceFactory.class).to(DefaultServiceFactory.class).in(Singleton.class);
        this.bind(BasicRequest.class).to(DefaultRequestImpl.class);
        this.install((Module)new QueryGuiceModule());
        this.install((Module)new BlastGuiceModule());
        this.install((Module)new JapiUniProtGuiceModule(this.clientConfigurator.getUniProtServiceURL()));
        this.install((Module)new JapiUniParcGuiceModule(this.clientConfigurator.getUniParcServiceURL()));
        this.install((Module)new JapiUniRefGuiceModule(this.clientConfigurator.getUniRefServiceURL()));
        this.install((Module)new InfoServiceGuiceModule(this.clientConfigurator.getInfoServiceURL()));
    }
}

