/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.examples;

import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.examples.PrintUtils;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class UniParcRetrievalExamples {
    private static final int DISPLAY_ENTRY_SIZE = 10;

    public static void main(String[] args) {
        LocalTime start = LocalTime.now();
        UniParcRetrievalExamples.driveExamples();
        LocalTime end = LocalTime.now();
        Duration duration = Duration.between(start, end);
        System.out.println("Duration=" + duration.getSeconds() + " seconds");
    }

    public static void driveExamples() {
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniParcService uniParcService = serviceFactoryInstance.getUniParcQueryService();
        try {
            uniParcService.start();
            UniParcRetrievalExamples.retrieveEntryUsingEntryIdentifier(uniParcService);
            UniParcRetrievalExamples.retrieveEntryUsingUniProtAccession(uniParcService);
            UniParcRetrievalExamples.retrieveEntriesUsingQuery(uniParcService);
            UniParcRetrievalExamples.retrieveUniParcSequencesUsingQuery(uniParcService);
        }
        catch (ServiceException e) {
            System.err.println("Error occurred whilst executing retrieval: " + e.getMessage());
        }
        finally {
            uniParcService.stop();
            System.out.println("service now stopped.");
        }
    }

    public static void retrieveEntryUsingEntryIdentifier(UniParcService uniParcService) throws ServiceException {
        PrintUtils.printExampleHeader("Retrieve UniParc entry using the UniParc entry identifier");
        String identifier = "UPI0000000001";
        System.out.println("Retrieve entry with id: " + identifier);
        UniParcEntry entry = uniParcService.getEntry(identifier);
        System.out.println(entry.getUniParcId().getValue());
    }

    public static void retrieveEntryUsingUniProtAccession(UniParcService uniParcService) throws ServiceException {
        PrintUtils.printExampleHeader("Retrieve UniParc entry with given UniProt accession");
        String accession = "P99999";
        System.out.println("Retrieve UniParc entry containing UniProt accession: " + accession);
        UniParcEntry entry = uniParcService.getEntryFromUniProtAccession(accession);
        System.out.println(entry.getUniParcId().getValue());
    }

    public static void retrieveEntriesUsingQuery(UniParcService uniParcService) throws ServiceException {
        PrintUtils.printExampleHeader("Retrieve a set of entries that match the query criteria");
        String organismName = "Homo sapiens";
        System.out.printf("Retrieve first %d UniParc entries that contain the given organism name: %s within at leastone of their database cross-references%n", 10, organismName);
        Query query = UniParcQueryBuilder.organismName(organismName);
        QueryResult<UniParcEntry> queryResult = uniParcService.getEntries(query);
        for (int entryCounter = 0; queryResult.hasNext() && entryCounter < 10; ++entryCounter) {
            UniParcEntry entry = (UniParcEntry)queryResult.next();
            System.out.println(entry.getUniParcId().getValue());
        }
    }

    public static void retrieveUniParcSequencesUsingQuery(UniParcService uniParcService) throws ServiceException {
        PrintUtils.printExampleHeader("Retrieve a set of UniParc sequences that match the query criteria");
        String organismName = "Homo sapiens";
        System.out.printf("Retrieve first %d UniParc entries that contain the given organism name: %s within at least one of their database cross-references%n", 10, organismName);
        Query query = UniParcQueryBuilder.organismName(organismName);
        QueryResult<UniParcComponent<Sequence>> queryResult = uniParcService.getSequences(query);
        for (int sequenceCounter = 0; queryResult.hasNext() && sequenceCounter < 10; ++sequenceCounter) {
            UniParcComponent entrySequence = (UniParcComponent)queryResult.next();
            UniParcRetrievalExamples.printEntrySequence(entrySequence);
        }
    }

    public static void printEntrySequence(UniParcComponent<Sequence> entrySequence) {
        Sequence sequence = UniParcRetrievalExamples.returnFirstSequence(entrySequence.getComponents());
        System.out.println("Entry {");
        System.out.println("\tId: " + entrySequence.getEntryIdentifier().getValue());
        System.out.println("\tSequence {");
        System.out.println("\t\tSequence: " + sequence.getValue());
        System.out.println("\t\tLength: " + sequence.getLength());
        System.out.println("\t\tChecksum: " + sequence.getCRC64());
        System.out.println("\t}");
        System.out.println("}");
    }

    public static Sequence returnFirstSequence(List<Sequence> sequences) {
        return sequences.get(0);
    }
}

