/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.inject.Singleton;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastAnnotations;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.DispatcherSubmissionService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.LazyUniRefHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.SummaryConverter;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.EBIApplicationResult;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THit;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THits;

@Singleton
class UniRefBlastServiceImpl
extends AbstractBlastService<UniRefHit, EBIApplicationResult>
implements UniRefBlastService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SummaryConverter<THit, BlastSummary> converter;
    private final UniRefService searchService;
    private boolean isStarted;

    @Inject
    public UniRefBlastServiceImpl(DispatcherSubmissionService<BlastInput, EBIApplicationResult> submissionService, @BlastAnnotations.GenericSummaryConverter SummaryConverter<THit, BlastSummary> converter, UniRefService uniRefService) {
        super(submissionService);
        this.converter = converter;
        this.searchService = uniRefService;
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.searchService.start();
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.searchService.stop();
            this.isStarted = false;
        }
    }

    @Override
    protected BlastResult<UniRefHit> buildBlastResult(EBIApplicationResult ebiResult, BlastInput input) {
        THits rawHits = ebiResult.getSequenceSimilaritySearchResult().getHits();
        BlastResultImpl<UniRefHit> blastResult = new BlastResultImpl<UniRefHit>();
        for (THit rawHit : rawHits.getHit()) {
            try {
                BlastSummary summary = this.converter.convert(rawHit);
                blastResult.addHit(new LazyUniRefHit(summary, this.searchService));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unable to process the following raw hit: {} for job with input: {}", (Object)rawHit, (Object)input);
            }
        }
        return blastResult;
    }

    @Override
    protected void checkBlastInput(BlastInput input) {
        if (input == null) {
            throw new IllegalArgumentException("Blast input can not be null");
        }
        input.getBlastDatabases().forEach(this::checkDatabase);
    }

    private void checkDatabase(DatabaseOption database) {
        switch (database) {
            case UNIREF_100: 
            case UNIREF_90: 
            case UNIREF_50: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided database option can not be processed by the UniParc blast service");
            }
        }
    }
}

