/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.inject.Singleton;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastAnnotations;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.DispatcherSubmissionService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.LazyUniParcHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.SummaryConverter;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.EBIApplicationResult;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THit;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THits;

@Singleton
class UniParcBlastServiceImpl
extends AbstractBlastService<UniParcHit, EBIApplicationResult>
implements UniParcBlastService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SummaryConverter<THit, BlastSummary> converter;
    private final UniParcService searchService;
    private boolean isStarted;

    @Inject
    public UniParcBlastServiceImpl(DispatcherSubmissionService<BlastInput, EBIApplicationResult> submissionService, @BlastAnnotations.GenericSummaryConverter SummaryConverter<THit, BlastSummary> converter, UniParcService uniParcService) {
        super(submissionService);
        this.converter = converter;
        this.searchService = uniParcService;
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.searchService.start();
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.searchService.stop();
            this.isStarted = false;
        }
    }

    @Override
    protected BlastResult<UniParcHit> buildBlastResult(EBIApplicationResult ebiResult, BlastInput input) {
        THits rawHits = ebiResult.getSequenceSimilaritySearchResult().getHits();
        BlastResultImpl<UniParcHit> blastResult = new BlastResultImpl<UniParcHit>();
        for (THit rawHit : rawHits.getHit()) {
            try {
                BlastSummary summary = this.converter.convert(rawHit);
                blastResult.addHit(new LazyUniParcHit(summary, this.searchService));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unable to process the following raw hit: {} for job with input: {}", (Object)rawHit, (Object)input);
            }
        }
        return blastResult;
    }

    @Override
    protected void checkBlastInput(BlastInput input) {
        if (input == null) {
            throw new IllegalArgumentException("Blast input can not be null");
        }
        input.getBlastDatabases().forEach(this::checkDatabase);
    }

    private void checkDatabase(DatabaseOption database) {
        switch (database) {
            case UNIPARC: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided database option can not be processed by the UniParc blast service: " + database.getDisplayName());
            }
        }
    }
}

