/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.sequence;

import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SequenceType;

public class SequenceHandler
implements GenericHandler<Sequence, SequenceType> {
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;

    public SequenceHandler(UniProtFactory uniProtFactory, ObjectFactory objectFactory) {
        this.uniProtFactory = uniProtFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public Sequence fromXmlBinding(SequenceType sequenceXML) {
        Sequence sequence = this.uniProtFactory.buildSequence();
        sequence.setCRC64(sequenceXML.getChecksum());
        sequence.setMolecularWeight(sequenceXML.getMass());
        String seq = sequenceXML.getValue();
        seq = seq.replaceAll(" ", "");
        seq = seq.replaceAll("\n", "");
        sequence.setValue(seq);
        return sequence;
    }

    @Override
    public SequenceType toXmlBinding(Sequence uniObj) {
        SequenceType sequenceXML = this.objectFactory.createSequenceType();
        sequenceXML.setChecksum(uniObj.getCRC64());
        sequenceXML.setLength(uniObj.getValue().length());
        sequenceXML.setMass(uniObj.getMolecularWeight());
        sequenceXML.setValue(uniObj.getValue());
        return sequenceXML;
    }
}

