/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.organism;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismNameType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;

public class NameUpdater
implements GenericUpdater<OrganismType, Organism> {
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;

    public NameUpdater(UniProtFactory uniProtFactory, ObjectFactory objectFactory) {
        this.uniProtFactory = uniProtFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public void fromXmlBinding(OrganismType xmlOrganism, Organism organism) {
        List<OrganismNameType> listNames = xmlOrganism.getName();
        for (OrganismNameType xmlName : listNames) {
            if (xmlName.getType().equalsIgnoreCase("scientific")) {
                organism.setScientificName(this.uniProtFactory.buildOrganismScientificName(xmlName.getValue()));
                continue;
            }
            if (xmlName.getType().equalsIgnoreCase("common")) {
                organism.setCommonName(this.uniProtFactory.buildOrganismCommonName(xmlName.getValue()));
                continue;
            }
            if (!xmlName.getType().equalsIgnoreCase("synonym")) continue;
            organism.setSynonym(this.uniProtFactory.buildOrganismSynonym(xmlName.getValue()));
        }
    }

    @Override
    public void toXmlBinding(Organism organism, OrganismType organismXML) {
        OrganismNameType organismNameXML = this.objectFactory.createOrganismNameType();
        organismNameXML.setType("scientific");
        organismNameXML.setValue(organism.getScientificName().getValue());
        organismXML.getName().add(organismNameXML);
        if (organism.hasCommonName()) {
            OrganismNameType commonName = this.objectFactory.createOrganismNameType();
            commonName.setType("common");
            commonName.setValue(organism.getCommonName().getValue());
            organismXML.getName().add(commonName);
        }
        if (organism.hasSynonym()) {
            OrganismNameType synonymName = this.objectFactory.createOrganismNameType();
            synonymName.setType("synonym");
            synonymName.setValue(organism.getSynonym().getValue());
            organismXML.getName().add(synonymName);
        }
    }
}

