/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.main;

import com.codahale.metrics.Timer;
import com.sun.xml.bind.marshaller.DataWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import uk.ac.ebi.kraken.parser.EntryBufferReader2;
import uk.ac.ebi.kraken.util.thread.LimitedQueue;
import uk.ac.ebi.kraken.util.thread.NamedThreadFactory;
import uk.ac.ebi.kraken.xml.common.XmlBuildStats;
import uk.ac.ebi.kraken.xml.common.XmlBuilder;
import uk.ac.ebi.kraken.xml.exception.UniProtXmlException;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.Entry;
import uk.ac.ebi.kraken.xml.merge.XmlFileMergerImpl2;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtFFToXmlConverter;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlBuildStats;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlConfigure;

public class UniProtXmlBuilder
implements XmlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniProtXmlBuilder.class);
    private static final String XML_FILE_PREX_RETRY = "_retry";
    private static final String FAILED_ENTRY_FILE_PREV = "failed_entries";
    private static final int MAX_RETRY = 3;
    private static final String XML_FILEEXT = ".xml";
    private final int BOLK_SIZE = 20;
    private String failedFileName;
    private final UniProtXmlBuildStats xmlBuildStats;
    private final UniProtXmlConfigure configure;

    public UniProtXmlBuilder(UniProtXmlConfigure configure) {
        this.configure = configure;
        this.xmlBuildStats = new UniProtXmlBuildStats(configure.metricsReportInterval());
    }

    @Override
    public XmlBuildStats build(List<String> dataFiles, String xmlFile) {
        LOGGER.info("UniProt Xml build start... ");
        String failedEntryFile = this.getFailedEntryFileName(0);
        ArrayList<String> outputFiles = new ArrayList<String>();
        int inc = 0;
        for (String dataFile : dataFiles) {
            try {
                LOGGER.info("Start building xml from ... " + dataFile);
                String threadNamePrefix = this.configure.getIntermFilePrefix() + inc++ + "-";
                String internFile = "threadNamePrefix" + LocalTime.now().getNano();
                if (!this.checkIfFileCanBeCreated(internFile)) {
                    throw new UniProtXmlException("Cannot create temp xml file, create check -imf option");
                }
                outputFiles.addAll(this.multithreadBuild(dataFile, threadNamePrefix, this.configure.nThreads(), failedEntryFile));
            }
            catch (UniProtXmlException e) {
                LOGGER.error("dataFile: " + dataFile + " failed to build. ", (Throwable)e);
            }
        }
        if (this.xmlBuildStats.getFailedCounter().getCount() > 0L) {
            outputFiles.addAll(this.retryBuild(failedEntryFile));
        } else {
            File file = new File(failedEntryFile);
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                LOGGER.warn("File: " + failedEntryFile + " cannot be deleted");
            }
        }
        this.mergeFiles(xmlFile, outputFiles);
        if (!this.configure.keepIntermFiles()) {
            this.deleteFiles(outputFiles);
        }
        this.updateStats(xmlFile, this.failedFileName);
        this.xmlBuildStats.metricsReport();
        return this.xmlBuildStats;
    }

    private boolean checkIfFileCanBeCreated(String filename) {
        File file = new File(filename);
        try {
            boolean canCreate = file.createNewFile();
            if (canCreate) {
                Files.deleteIfExists(file.toPath());
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateStats(String xmlFile, String failedEntryFile) {
        File file = new File(xmlFile);
        if (file.exists()) {
            this.xmlBuildStats.setOutputFile(file.getAbsolutePath());
        } else {
            this.xmlBuildStats.setOutputFile(xmlFile);
        }
        if (failedEntryFile != null) {
            file = new File(failedEntryFile);
            if (file.exists()) {
                this.xmlBuildStats.setFailedEntryFile(file.getAbsolutePath());
            } else {
                this.xmlBuildStats.setFailedEntryFile(failedEntryFile);
            }
        }
    }

    private void mergeFiles(String xmlFile, List<String> inputFiles) {
        LOGGER.info("merge files from ... " + inputFiles);
        LOGGER.info("merge to ... " + xmlFile);
        LocalTime start = LocalTime.now();
        XmlFileMergerImpl2 xmFileMerger = new XmlFileMergerImpl2("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<uniprot xmlns=\"http://uniprot.org/uniprot\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://uniprot.org/uniprot http://www.uniprot.org/docs/uniprot.xsd\">\n", "<copyright>\nCopyrighted by the UniProt Consortium, see https://www.uniprot.org/terms Distributed under the Creative Commons Attribution (CC BY 4.0) License\n</copyright>\n</uniprot>");
        try {
            xmFileMerger.mergeFiles(xmlFile, inputFiles, this.configure.includeHeaderFooder());
        }
        catch (IOException e) {
            throw new UniProtXmlException("failed to merge files", e);
        }
        finally {
            Duration duration = Duration.between(start, LocalTime.now());
            LOGGER.info("Time for merging file: " + duration.getSeconds() + " seconds");
        }
    }

    private void deleteFiles(List<String> inputFiles) {
        for (String inputFile : inputFiles) {
            File file = new File(inputFile);
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                LOGGER.warn("File: " + inputFile + " cannot be deleted");
            }
        }
    }

    private String getFailedEntryFileName(int retry) {
        return FAILED_ENTRY_FILE_PREV + LocalTime.now().toSecondOfDay() + retry + ".txt";
    }

    private List<String> retryBuild(String failedEntryFile) {
        int nretry = 1;
        ArrayList<String> outputFiles = new ArrayList<String>();
        String dataFile = failedEntryFile;
        do {
            LOGGER.info("Number of failed Entries: " + this.xmlBuildStats.getFailedCounter().getCount());
            LOGGER.info("Retry build failed entries: " + nretry);
            String newFailedEntryFile = this.getFailedEntryFileName(nretry);
            String xmlfilePrex = this.configure.getIntermFilePrefix() + XML_FILE_PREX_RETRY + nretry;
            outputFiles.addAll(this.multithreadBuild(dataFile, xmlfilePrex, 1, newFailedEntryFile));
            if (this.xmlBuildStats.getFailedCounter().getCount() <= 0L) break;
            this.deletePreviousFailedEntryFile(dataFile);
            dataFile = newFailedEntryFile;
        } while (++nretry >= 3);
        return outputFiles;
    }

    private void deletePreviousFailedEntryFile(String file) {
        try {
            Files.deleteIfExists(Paths.get(file, new String[0]));
        }
        catch (IOException e) {
            LOGGER.warn("File: " + file + " cannot be deleted");
        }
    }

    private List<String> multithreadBuild(String dataFile, String xmlfilePrev, int nthread, String failedEntryFile) {
        Object ffEntries;
        this.failedFileName = failedEntryFile;
        long failed = this.xmlBuildStats.getFailedCounter().getCount();
        this.xmlBuildStats.getFailedCounter().dec(failed);
        LimitedQueue<Runnable> queue = new LimitedQueue<Runnable>(10000);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(nthread, 32, 30L, TimeUnit.SECONDS, queue, new NamedThreadFactory(xmlfilePrev));
        EntryBufferReader2 entryBufferReader2 = null;
        PrintWriter failedEntryWriter = null;
        try {
            failedEntryWriter = new PrintWriter(new FileWriter(new File(failedEntryFile)));
        }
        catch (IOException e) {
            failedEntryWriter = new PrintWriter(new OutputStreamWriter(System.out));
        }
        try {
            entryBufferReader2 = new EntryBufferReader2(dataFile);
        }
        catch (Exception e) {
            throw new UniProtXmlException("Parsing Flatfile failure.", e);
        }
        int counter = 0;
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        while (!(ffEntries = this.getNextListFFEntries(entryBufferReader2)).isEmpty()) {
            this.xmlBuildStats.getFlatfileEntryCounter().inc((long)ffEntries.size());
            futures.add(executorService.submit(new UniProtFF2XmlWriter((List<String>)ffEntries, this.configure.getHumdiseaseFilePath(), this.configure.getKeywordFilePath(), failedEntryWriter, this.xmlBuildStats)));
            ++counter;
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new UniProtXmlException(e);
        }
        failedEntryWriter.close();
        this.xmlBuildStats.metricsReport();
        return this.getxmlFiles(xmlfilePrev, nthread > counter ? counter : nthread);
    }

    private List<String> getxmlFiles(String xmlfilePrev, int nthread) {
        return IntStream.range(1, nthread + 1).mapToObj(val -> xmlfilePrev + val + XML_FILEEXT).collect(Collectors.toList());
    }

    private List<String> getNextListFFEntries(EntryBufferReader2 entryBufferReader2) {
        Timer.Context time = this.xmlBuildStats.getFfReadTimer().time();
        ArrayList<String> entries = new ArrayList<String>(20);
        int count = 0;
        do {
            String next = null;
            try {
                next = entryBufferReader2.next();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (next == null) break;
            entries.add(next);
        } while (++count < 20);
        time.stop();
        return entries;
    }

    static class UniProtFF2XmlWriter
    implements Callable<String> {
        private static final ConcurrentHashMap<String, UniProtFFToXmlConverter> converters = new ConcurrentHashMap();
        private static final ConcurrentHashMap<String, Marshaller> marshallers = new ConcurrentHashMap();
        private static final ConcurrentHashMap<String, DataWriter> writers = new ConcurrentHashMap();
        private final String humdiseaseFilePath;
        private final String keywordFilePath;
        private final List<String> ffEntries;
        private final PrintWriter failedEntryWriter;
        private UniProtXmlBuildStats metrics;

        public UniProtFF2XmlWriter(List<String> ffEntries, String humdiseaseFilePath, String keywordFilePath, PrintWriter failedEntryWriter, UniProtXmlBuildStats metrics) {
            this.ffEntries = ffEntries;
            this.keywordFilePath = keywordFilePath;
            this.humdiseaseFilePath = humdiseaseFilePath;
            this.failedEntryWriter = failedEntryWriter;
            this.metrics = metrics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            UniProtFFToXmlConverter converter = this.getUniprotFFToXmlConverter(threadName);
            DataWriter writer = this.getWriter(threadName);
            Marshaller marshaller = this.getMarshaller(threadName);
            for (String ffEntry : this.ffEntries) {
                Timer.Context time1 = this.metrics.getEntryParseTimer().time();
                Entry xmlEntry = null;
                try {
                    xmlEntry = converter.apply(ffEntry);
                }
                catch (Exception e) {
                    this.metrics.getFailedCounter().inc();
                    this.writeFailedFFEntry(ffEntry);
                }
                finally {
                    time1.stop();
                }
                if (xmlEntry == null) continue;
                Timer.Context time2 = this.metrics.getXmlWriteTimer().time();
                try {
                    marshaller.marshal((Object)xmlEntry, (ContentHandler)writer);
                    writer.characters("\n");
                    writer.flush();
                    this.metrics.getSucceededCounter().inc();
                }
                catch (Exception e) {
                    LOGGER.warn("Entry write to XML Failed." + xmlEntry.getAccession().get(0));
                    this.metrics.getFailedCounter().inc();
                    this.writeFailedFFEntry(ffEntry);
                }
                finally {
                    time2.stop();
                }
            }
            return threadName + UniProtXmlBuilder.XML_FILEEXT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFailedFFEntry(String ffEntry) {
            PrintWriter printWriter = this.failedEntryWriter;
            synchronized (printWriter) {
                this.failedEntryWriter.write(ffEntry);
                this.failedEntryWriter.flush();
            }
        }

        private DataWriter getWriter(String name) {
            DataWriter writer = writers.get(name);
            if (writer == null) {
                try {
                    writer = this.getXmlWriter(name + UniProtXmlBuilder.XML_FILEEXT);
                    writers.put(name, writer);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not create temp xml file: " + name + UniProtXmlBuilder.XML_FILEEXT);
                }
            }
            return writer;
        }

        public void setWriter(String name, DataWriter writer) {
            writers.put(name, writer);
        }

        private DataWriter getXmlWriter(String filename) throws IOException {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(filename)));
            DataWriter writer = new DataWriter((Writer)out, "UTF-8");
            writer.setIndentStep("  ");
            return writer;
        }

        private UniProtFFToXmlConverter getUniprotFFToXmlConverter(String name) {
            UniProtFFToXmlConverter converter = converters.get(name);
            if (converter == null) {
                converter = new UniProtFFToXmlConverter(this.humdiseaseFilePath, this.keywordFilePath);
                converters.put(name, converter);
            }
            return converter;
        }

        private Marshaller getMarshaller(String name) {
            Marshaller marshaller = marshallers.get(name);
            if (marshaller == null) {
                marshaller = this.initXmlMarshaller();
                marshallers.put(name, marshaller);
            }
            return marshaller;
        }

        private Marshaller initXmlMarshaller() {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniprot");
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                return marshaller;
            }
            catch (Exception e) {
                throw new UniProtXmlException("JAXB initiallation failed", e);
            }
        }
    }
}

