/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.gene;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.annotations.XMLTagName;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.GeneNameType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.GeneType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class GeneHandler
implements GenericHandler<Gene, GeneType> {
    private final ObjectFactory xmlUniprotFactory;
    private final UniProtFactory uniprotFactory;
    private EvidenceReferenceHandler evidenceReferenceHandler;

    public GeneHandler() {
        this(DefaultUniProtFactory.getInstance(), new ObjectFactory());
    }

    public GeneHandler(UniProtFactory uniprotFactory, ObjectFactory xmlUniprotFactory) {
        this(uniprotFactory, xmlUniprotFactory, null);
    }

    public GeneHandler(UniProtFactory uniprotFactory, ObjectFactory xmlUniprotFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.uniprotFactory = uniprotFactory;
        this.xmlUniprotFactory = xmlUniprotFactory;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    public void setEvidenceReferenceHandler(EvidenceReferenceHandler evidenceReferenceHandler) {
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    @Override
    public Gene fromXmlBinding(GeneType xmlGene) {
        Gene gene = this.uniprotFactory.buildGene();
        String geneNameXMLTag = GeneName.class.getAnnotation(XMLTagName.class).tagName();
        String geneNameSynonymXMLTag = GeneNameSynonym.class.getAnnotation(XMLTagName.class).tagName();
        String orderedLocusNameXMLTag = OrderedLocusName.class.getAnnotation(XMLTagName.class).tagName();
        String orfNameXMLTag = ORFName.class.getAnnotation(XMLTagName.class).tagName();
        List<GeneNameType> listNames = xmlGene.getName();
        ArrayList<GeneNameSynonym> listSyonyms = new ArrayList<GeneNameSynonym>();
        ArrayList<OrderedLocusName> listOrderedLocus = new ArrayList<OrderedLocusName>();
        ArrayList<ORFName> listORFNames = new ArrayList<ORFName>();
        for (GeneNameType geneNameType : listNames) {
            if (geneNameType.getType().equalsIgnoreCase(geneNameXMLTag)) {
                GeneName geneName = this.uniprotFactory.buildGeneName(geneNameType.getValue());
                this.addEvidencetoObj(geneName, geneNameType);
                gene.setGeneName(geneName);
                continue;
            }
            if (geneNameType.getType().equalsIgnoreCase(geneNameSynonymXMLTag)) {
                GeneNameSynonym syn = this.uniprotFactory.buildGeneNameSynonym(geneNameType.getValue());
                this.addEvidencetoObj(syn, geneNameType);
                listSyonyms.add(syn);
                continue;
            }
            if (geneNameType.getType().equalsIgnoreCase(orderedLocusNameXMLTag)) {
                OrderedLocusName ol = this.uniprotFactory.buildOrderedLocusName(geneNameType.getValue());
                this.addEvidencetoObj(ol, geneNameType);
                listOrderedLocus.add(ol);
                continue;
            }
            if (!geneNameType.getType().equalsIgnoreCase(orfNameXMLTag)) continue;
            ORFName orf = this.uniprotFactory.buildORFName(geneNameType.getValue());
            this.addEvidencetoObj(orf, geneNameType);
            listORFNames.add(orf);
        }
        gene.setGeneNameSynonyms(listSyonyms);
        gene.setOrderedLocusNames(listOrderedLocus);
        gene.setORFNames(listORFNames);
        return gene;
    }

    @Override
    public GeneType toXmlBinding(Gene gene) {
        String geneNameXMLTag = GeneName.class.getAnnotation(XMLTagName.class).tagName();
        String geneNameSynonymXMLTag = GeneNameSynonym.class.getAnnotation(XMLTagName.class).tagName();
        String orderedLocusNameXMLTag = OrderedLocusName.class.getAnnotation(XMLTagName.class).tagName();
        String orfNameXMLTag = ORFName.class.getAnnotation(XMLTagName.class).tagName();
        GeneType xmlGene = this.xmlUniprotFactory.createGeneType();
        List<GeneNameType> listNames = xmlGene.getName();
        if (gene.hasGeneName()) {
            GeneNameType geneNameXml = this.xmlUniprotFactory.createGeneNameType();
            geneNameXml.setType(geneNameXMLTag);
            geneNameXml.setValue(gene.getGeneName().getValue());
            this.addEvidencetoXML(gene.getGeneName(), geneNameXml);
            listNames.add(geneNameXml);
        }
        for (GeneNameSynonym geneNameSynonym : gene.getGeneNameSynonyms()) {
            GeneNameType geneSynXml = this.xmlUniprotFactory.createGeneNameType();
            geneSynXml.setType(geneNameSynonymXMLTag);
            geneSynXml.setValue(geneNameSynonym.getValue());
            this.addEvidencetoXML(geneNameSynonym, geneSynXml);
            listNames.add(geneSynXml);
        }
        for (OrderedLocusName orderedLocusName : gene.getOrderedLocusNames()) {
            GeneNameType geneOrderedLocusNameXml = this.xmlUniprotFactory.createGeneNameType();
            geneOrderedLocusNameXml.setType(orderedLocusNameXMLTag);
            geneOrderedLocusNameXml.setValue(orderedLocusName.getValue());
            this.addEvidencetoXML(orderedLocusName, geneOrderedLocusNameXml);
            listNames.add(geneOrderedLocusNameXml);
        }
        for (ORFName orfName : gene.getORFNames()) {
            GeneNameType geneORFNameXml = this.xmlUniprotFactory.createGeneNameType();
            geneORFNameXml.setType(orfNameXMLTag);
            geneORFNameXml.setValue(orfName.getValue());
            this.addEvidencetoXML(orfName, geneORFNameXml);
            listNames.add(geneORFNameXml);
        }
        return xmlGene;
    }

    private void addEvidencetoXML(HasEvidences evidences, GeneNameType geneNameXml) {
        List<Integer> evs;
        if (!evidences.getEvidenceIds().isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(evidences.getEvidenceIds())).isEmpty()) {
            geneNameXml.getEvidence().addAll(evs);
        }
    }

    private void addEvidencetoObj(HasEvidences evidences, GeneNameType geneNameXml) {
        if (!geneNameXml.getEvidence().isEmpty()) {
            evidences.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(geneNameXml.getEvidence()));
        }
    }
}

