/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydLinkType;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.parser.FeatureHelper;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.feature.CommonFeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.DescriptionHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureIdHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.StatusHandlerStrategy;

public class CarbohydHandlerStrategy
extends CommonFeatureHandlerStrategy<CarbohydFeature> {
    public CarbohydHandlerStrategy(FeatureFactory featureFactory, ObjectFactory xmlUniprotFactory, LocationHandlerStrategy locationHandlerStrategy, StatusHandlerStrategy statusHandlerStrategy, DescriptionHandlerStrategy descriptionHandlerStrategy, FeatureIdHandlerStrategy featureIdHandlerStrategy) {
        super(featureFactory, xmlUniprotFactory, locationHandlerStrategy, statusHandlerStrategy, descriptionHandlerStrategy, featureIdHandlerStrategy);
    }

    @Override
    public void featureFromXmlBinding(CarbohydFeature feature, FeatureType xmlFeature) {
        super.featureFromXmlBinding(feature, xmlFeature);
        this.carbohydFeatureFromXmlBinding(feature, xmlFeature);
    }

    private void carbohydFeatureFromXmlBinding(CarbohydFeature feature, FeatureType xmlFeature) {
        String description = xmlFeature.getDescription();
        if (description != null) {
            String annotation = FeatureHelper.consumeCarbohydFeature(feature, description);
            if (".".equals(annotation)) {
                annotation = "";
            }
            if (annotation.endsWith(".")) {
                annotation = annotation.substring(0, annotation.length() - 1);
            }
            feature.setFeatureDescription(DefaultFeatureFactory.getInstance().buildFeatureDescription(annotation.trim()));
        }
    }

    @Override
    public void featureToXmlBinding(CarbohydFeature feature, FeatureType xmlFeature) {
        super.featureToXmlBinding(feature, xmlFeature);
        this.carbohydFeatureToXmlBinding(feature, xmlFeature);
    }

    private void carbohydFeatureToXmlBinding(CarbohydFeature feature, FeatureType xmlFeature) {
        String description;
        String sugar = feature.getLinkedSugar().getValue();
        String linkedType = feature.getCarbohydLinkType().getValue();
        StringBuilder sb = new StringBuilder();
        if (!feature.getCarbohydLinkType().equals((Object)CarbohydLinkType.UNKNOWN)) {
            sb.append(linkedType);
        }
        if (!sugar.isEmpty()) {
            sb.append(" ").append(sugar);
        }
        if (!"".equals(description = feature.getFeatureDescription().getValue())) {
            if (description.indexOf(40) == 0) {
                sb.append(" ");
            } else {
                sb.append("; ");
            }
            sb.append(description);
        }
        xmlFeature.setDescription(sb.toString());
    }
}

