/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.dbxref;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.util.XMLDBXrefHelper;

public class DefaultDbXrefHandler
implements GenericHandler<DatabaseCrossReference, DbReferenceType> {
    private ObjectFactory objectFactory = new ObjectFactory();
    private GenericHandler<DatabaseCrossReference, DbReferenceType> baseDbXrefHandler;

    public DefaultDbXrefHandler(GenericHandler<DatabaseCrossReference, DbReferenceType> baseDbXrefHandler) {
        this.baseDbXrefHandler = baseDbXrefHandler;
    }

    @Override
    public DatabaseCrossReference fromXmlBinding(DbReferenceType xmlObject) {
        DatabaseCrossReference dbXref = this.baseDbXrefHandler.fromXmlBinding(xmlObject);
        XMLDBXrefHelper.createDBRefFromXML(dbXref, xmlObject.getProperty());
        if (xmlObject.getMolecule() != null && xmlObject.getMolecule().getId() != null) {
            dbXref.setIsoformId(DefaultUniProtFactory.getInstance().buildUniProtIsoformId(xmlObject.getMolecule().getId()));
        }
        return dbXref;
    }

    @Override
    public DbReferenceType toXmlBinding(DatabaseCrossReference dbXref) {
        DbReferenceType xmlReference = this.baseDbXrefHandler.toXmlBinding(dbXref);
        XMLDBXrefHelper.createXMLFromDBRef(xmlReference, dbXref);
        if (dbXref.getIsoformId() != null && !dbXref.getIsoformId().getValue().isEmpty()) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setId(dbXref.getIsoformId().getValue());
            xmlReference.setMolecule(mol);
        }
        return xmlReference;
    }
}

