/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.dbxref;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.dbxref.BaseDbXrefHandler;
import uk.ac.ebi.kraken.xml.uniprot.dbxref.DefaultDbXrefHandler;
import uk.ac.ebi.kraken.xml.uniprot.dbxref.GoDbXrefHandler;

public class DbXrefHandlerFactory {
    private final GenericHandler<DatabaseCrossReference, DbReferenceType> baseHandler;
    private final GenericHandler<DatabaseCrossReference, DbReferenceType> goHandler;
    private final GenericHandler<DatabaseCrossReference, DbReferenceType> defaultHandler;

    public DbXrefHandlerFactory(ObjectFactory objectFactory, DefaultXRefFactory defaultXRefFactory) {
        this.baseHandler = new BaseDbXrefHandler(defaultXRefFactory, objectFactory);
        this.goHandler = new GoDbXrefHandler(defaultXRefFactory, objectFactory, this.baseHandler);
        this.defaultHandler = new DefaultDbXrefHandler(this.baseHandler);
    }

    public GenericHandler<DatabaseCrossReference, DbReferenceType> createHandler(DatabaseType dbType) {
        if (dbType == DatabaseType.GO) {
            return this.goHandler;
        }
        if (dbType == DatabaseType.UNKNOWN) {
            return this.baseHandler;
        }
        return this.defaultHandler;
    }

    public GenericHandler<DatabaseCrossReference, DbReferenceType> createHandler(DbReferenceType dbReferenceType) {
        return this.createHandler(DatabaseType.getDatabaseType(dbReferenceType.getType()));
    }

    public GenericHandler<DatabaseCrossReference, DbReferenceType> createHandler(DatabaseCrossReference dbXref) {
        return this.createHandler(dbXref.getDatabase());
    }
}

