/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class RedoxPotentialHandler
implements GenericHandler<RedoxPotential, CommentType.RedoxPotential> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidencedValueHandler evidencedValueHandler;

    public RedoxPotentialHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler);
    }

    @Override
    public RedoxPotential fromXmlBinding(CommentType.RedoxPotential xmlObject) {
        if (xmlObject != null && !xmlObject.getText().isEmpty()) {
            RedoxPotential redoxPotential = this.commentFactory.buildRedoxPotential();
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            for (EvidencedStringType valXml : xmlObject.getText()) {
                evValues.add(this.evidencedValueHandler.fromXmlBinding(valXml));
            }
            redoxPotential.setTexts(evValues);
            return redoxPotential;
        }
        return null;
    }

    @Override
    public CommentType.RedoxPotential toXmlBinding(RedoxPotential object) {
        if (object != null && !object.getTexts().isEmpty()) {
            CommentType.RedoxPotential redoxXml = this.objectFactory.createCommentTypeRedoxPotential();
            for (EvidencedValue evValue : object.getTexts()) {
                EvidencedStringType valXml = this.evidencedValueHandler.toXmlBinding(evValue);
                redoxXml.getText().add(valXml);
            }
            return redoxXml;
        }
        return null;
    }
}

