/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.common;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationSummary;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SourceDataType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CommonReferenceUpdater
implements GenericUpdater<Citation, ReferenceType> {
    private final GenericHandler<CitationSummary, String> scopeHandler;
    private final GenericHandler<List<SampleSource>, SourceDataType> sampleSourceHandler;
    private GenericUpdater<Citation, CitationType> commonCitationUpdater;
    private final EvidenceReferenceHandler evidenceReferenceHandler;

    public CommonReferenceUpdater(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.evidenceReferenceHandler = evidenceReferenceHandler;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.commonCitationUpdater = itemFactory.buildCommonCitationUpdater();
        this.scopeHandler = itemFactory.buildScopeHandler();
        this.sampleSourceHandler = itemFactory.buildSampleSourceHandler();
    }

    @Override
    public void fromXmlBinding(Citation citation, ReferenceType referenceXML) {
        if (referenceXML != null) {
            List<SampleSource> sources;
            if (referenceXML.getCitation() == null) {
                return;
            }
            this.commonCitationUpdater.fromXmlBinding(citation, referenceXML.getCitation());
            ArrayList<CitationSummary> citationSummaryList = new ArrayList<CitationSummary>();
            List<String> listScopesXML = referenceXML.getScope();
            if (listScopesXML != null) {
                for (String s : listScopesXML) {
                    citationSummaryList.add(this.scopeHandler.fromXmlBinding(s));
                }
                citation.setCitationSummary(citationSummaryList);
            }
            if ((sources = this.sampleSourceHandler.fromXmlBinding(referenceXML.getSource())) != null) {
                citation.setSampleSources(sources);
            }
            if (!referenceXML.getEvidence().isEmpty()) {
                citation.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(referenceXML.getEvidence()));
            }
        }
    }

    @Override
    public void toXmlBinding(ReferenceType referenceXML, Citation citation) {
        List<Integer> ev;
        SourceDataType sourceDataType;
        this.commonCitationUpdater.toXmlBinding(referenceXML.getCitation(), citation);
        if (citation.getCitationSummary() != null) {
            List<CitationSummary> citationSummaryList = citation.getCitationSummary();
            for (CitationSummary citationSummary : citationSummaryList) {
                referenceXML.getScope().add(this.scopeHandler.toXmlBinding(citationSummary));
            }
        }
        if (citation.getSampleSources() != null && (sourceDataType = this.sampleSourceHandler.toXmlBinding(citation.getSampleSources())) != null) {
            referenceXML.setSource(sourceDataType);
        }
        if (!citation.getEvidenceIds().isEmpty() && !(ev = this.evidenceReferenceHandler.writeEvidenceIDs(citation.getEvidenceIds())).isEmpty()) {
            referenceXML.getEvidence().addAll(ev);
        }
    }
}

