/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.common;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ConsortiumType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.NameListType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.common.AuthorAndConsortiumHandler;

public class AuthoringGroupListHandler
implements AuthorAndConsortiumHandler<AuthoringGroup> {
    private final ObjectFactory objectFactory;
    private final GenericHandler<AuthoringGroup, String> authoringGroupHandler;

    public AuthoringGroupListHandler(CitationNewFactory citationFactory, ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        this.authoringGroupHandler = itemFactory.buildAuthoringGroupHandler();
    }

    @Override
    public List<AuthoringGroup> fromJAXB(CitationType citationXML) {
        if (citationXML == null || citationXML.getAuthorList() == null) {
            return null;
        }
        NameListType authorListXML = citationXML.getAuthorList();
        List<Object> listPersonOrConsortium = authorListXML.getConsortiumOrPerson();
        ArrayList<AuthoringGroup> authoringGroupList = new ArrayList<AuthoringGroup>();
        for (Object o : listPersonOrConsortium) {
            if (!(o instanceof ConsortiumType)) continue;
            ConsortiumType consortium = (ConsortiumType)o;
            authoringGroupList.add(this.authoringGroupHandler.fromXmlBinding(consortium.getName()));
        }
        return authoringGroupList;
    }

    @Override
    public NameListType toJAXB(Citation citation) {
        if (citation == null) {
            return null;
        }
        if (citation.getAuthoringGroup() != null && !citation.getAuthoringGroup().isEmpty()) {
            ArrayList<ConsortiumType> listPersonOrConsortium = new ArrayList<ConsortiumType>();
            NameListType authoringGroupListXML = this.objectFactory.createNameListType();
            List<AuthoringGroup> listAuthoringGroup = citation.getAuthoringGroup();
            for (AuthoringGroup authoringGroup : listAuthoringGroup) {
                ConsortiumType consortiumXML = this.objectFactory.createConsortiumType();
                consortiumXML.setName(this.authoringGroupHandler.toXmlBinding(authoringGroup));
                listPersonOrConsortium.add(consortiumXML);
            }
            if (!listPersonOrConsortium.isEmpty()) {
                authoringGroupListXML.getConsortiumOrPerson().addAll(listPersonOrConsortium);
            }
            return authoringGroupListXML;
        }
        return null;
    }
}

