/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSourceType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SourceDataType;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SampleSourceHandler
implements GenericHandler<List<SampleSource>, SourceDataType> {
    private static final Logger logger = LoggerFactory.getLogger(SampleSourceHandler.class);
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final Comparator<SampleSource> sampleSourceComparator = new SampleSourceComparator();
    private static final SampleSourceType[] order = new SampleSourceType[]{SampleSourceType.STRAIN, SampleSourceType.PLASMID, SampleSourceType.TRANSPOSON, SampleSourceType.TISSUE};
    private static final List<SampleSourceType> orderList = Arrays.asList(order);

    public SampleSourceHandler(CitationNewFactory citationFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.citationFactory = citationFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    @Override
    public List<SampleSource> fromXmlBinding(SourceDataType XML) {
        ArrayList<SampleSource> sampleSourceList = new ArrayList<SampleSource>();
        if (XML != null) {
            List<Object> listSourceXML = XML.getStrainOrPlasmidOrTransposon();
            for (Object o : listSourceXML) {
                SampleSource sampleSource = null;
                if (o instanceof SourceDataType.Plasmid) {
                    SourceDataType.Plasmid plasmid = (SourceDataType.Plasmid)o;
                    sampleSource = this.citationFactory.buildSampleSource(SampleSourceType.PLASMID, plasmid.getValue());
                    sampleSource.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(plasmid.getEvidence()));
                } else if (o instanceof SourceDataType.Strain) {
                    SourceDataType.Strain strain = (SourceDataType.Strain)o;
                    sampleSource = this.citationFactory.buildSampleSource(SampleSourceType.STRAIN, strain.getValue());
                    sampleSource.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(strain.getEvidence()));
                } else if (o instanceof SourceDataType.Tissue) {
                    SourceDataType.Tissue tissue = (SourceDataType.Tissue)o;
                    sampleSource = this.citationFactory.buildSampleSource(SampleSourceType.TISSUE, tissue.getValue());
                    sampleSource.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(tissue.getEvidence()));
                } else if (o instanceof SourceDataType.Transposon) {
                    SourceDataType.Transposon transposon = (SourceDataType.Transposon)o;
                    sampleSource = this.citationFactory.buildSampleSource(SampleSourceType.TRANSPOSON, transposon.getValue());
                    sampleSource.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(transposon.getEvidence()));
                }
                sampleSourceList.add(sampleSource);
            }
            return sampleSourceList;
        }
        return null;
    }

    @Override
    public SourceDataType toXmlBinding(List<SampleSource> sampleSourceList) {
        SourceDataType sourceDataXML = this.objectFactory.createSourceDataType();
        Collections.sort(sampleSourceList, this.sampleSourceComparator);
        block6: for (SampleSource sampleSource : sampleSourceList) {
            SampleSourceType sampleSourceType = sampleSource.getType();
            if (sampleSource.getValue() == null || sampleSource.getValue().trim().length() == 0) {
                logger.error("No sequence sample source detected ");
                continue;
            }
            switch (sampleSourceType) {
                case PLASMID: {
                    SourceDataType.Plasmid plasmid = this.objectFactory.createSourceDataTypePlasmid();
                    plasmid.setValue(sampleSource.getValue());
                    sourceDataXML.getStrainOrPlasmidOrTransposon().add(plasmid);
                    if (sampleSource.getEvidenceIds().isEmpty()) break;
                    List<Integer> evs = this.evidenceReferenceHandler.writeEvidenceIDs(sampleSource.getEvidenceIds());
                    if (evs.isEmpty()) continue block6;
                    plasmid.getEvidence().addAll(evs);
                    break;
                }
                case STRAIN: {
                    SourceDataType.Strain strain = this.objectFactory.createSourceDataTypeStrain();
                    strain.setValue(sampleSource.getValue());
                    sourceDataXML.getStrainOrPlasmidOrTransposon().add(strain);
                    if (sampleSource.getEvidenceIds().isEmpty()) break;
                    List<Integer> evs = this.evidenceReferenceHandler.writeEvidenceIDs(sampleSource.getEvidenceIds());
                    if (evs.isEmpty()) continue block6;
                    strain.getEvidence().addAll(evs);
                    break;
                }
                case TISSUE: {
                    SourceDataType.Tissue tissue = this.objectFactory.createSourceDataTypeTissue();
                    tissue.setValue(sampleSource.getValue());
                    sourceDataXML.getStrainOrPlasmidOrTransposon().add(tissue);
                    if (sampleSource.getEvidenceIds().isEmpty()) break;
                    List<Integer> evs = this.evidenceReferenceHandler.writeEvidenceIDs(sampleSource.getEvidenceIds());
                    if (evs.isEmpty()) continue block6;
                    tissue.getEvidence().addAll(evs);
                    break;
                }
                case TRANSPOSON: {
                    List<Integer> evs;
                    SourceDataType.Transposon transposon = this.objectFactory.createSourceDataTypeTransposon();
                    transposon.setValue(sampleSource.getValue());
                    sourceDataXML.getStrainOrPlasmidOrTransposon().add(transposon);
                    if (sampleSource.getEvidenceIds().isEmpty() || (evs = this.evidenceReferenceHandler.writeEvidenceIDs(sampleSource.getEvidenceIds())).isEmpty()) break;
                    transposon.getEvidence().addAll(evs);
                }
            }
        }
        if (sourceDataXML.getStrainOrPlasmidOrTransposon().isEmpty()) {
            return null;
        }
        return sourceDataXML;
    }

    private class SampleSourceComparator
    implements Comparator<SampleSource> {
        private SampleSourceComparator() {
        }

        @Override
        public int compare(SampleSource o1, SampleSource o2) {
            if (orderList.indexOf((Object)o1.getType()) > orderList.indexOf((Object)o2.getType())) {
                return 1;
            }
            if (orderList.indexOf((Object)o1.getType()) < orderList.indexOf((Object)o2.getType())) {
                return -1;
            }
            return 0;
        }
    }
}

