/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniparc;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.UniParcFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.Domain;
import uk.ac.ebi.kraken.interfaces.uniparc.Location;
import uk.ac.ebi.kraken.interfaces.uniparc.SequenceFeature;
import uk.ac.ebi.kraken.interfaces.uniparc.SignatureDBType;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.LocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.SeqFeatureGroupType;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.SeqFeatureType;

public class SequenceFeatureConverter {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final UniParcFactory uniParcFactory = DefaultUniParcFactory.getInstance();

    public SeqFeatureType toXml(SequenceFeature seqFeature) {
        SeqFeatureType sfType = this.objectFactory.createSeqFeatureType();
        sfType.setDatabase(seqFeature.getSignatureDBType().getName());
        sfType.setId(seqFeature.getDbId());
        sfType.setIpr(this.toXml(seqFeature.getDomain()));
        seqFeature.getLocations().stream().map(this::toXml).forEach(sfType.getLcn()::add);
        return sfType;
    }

    public SequenceFeature fromXml(SeqFeatureType seqFeatType) {
        SequenceFeature seqFeature = this.uniParcFactory.buildSequenceFeature();
        seqFeature.setSignatureDBType(SignatureDBType.getType(seqFeatType.getDatabase()));
        seqFeature.setDbId(seqFeatType.getId());
        seqFeature.setDomain(this.fromXml(seqFeatType.getIpr()));
        seqFeature.setLocations(seqFeatType.getLcn().stream().map(this::fromXml).collect(Collectors.toList()));
        return seqFeature;
    }

    public SeqFeatureGroupType toXml(Domain domain) {
        SeqFeatureGroupType group = this.objectFactory.createSeqFeatureGroupType();
        group.setName(domain.getName());
        group.setId(domain.getId());
        return group;
    }

    public Domain fromXml(SeqFeatureGroupType group) {
        return this.uniParcFactory.buildDomain(group.getName(), group.getId());
    }

    public LocationType toXml(Location location) {
        LocationType locationType = this.objectFactory.createLocationType();
        locationType.setStart(location.getStart());
        locationType.setEnd(location.getEnd());
        return locationType;
    }

    public Location fromXml(LocationType locationType) {
        return this.uniParcFactory.buildLocation(locationType.getStart(), locationType.getEnd());
    }
}

