/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.test;

import java.util.HashMap;
import java.util.StringTokenizer;

public class TremblEntryText {
    private String text;
    private HashMap<String, Integer> hierarchy;

    public TremblEntryText() {
        this.generateDefaultEntryText();
        this.initLineHierarchy();
    }

    private void initLineHierarchy() {
        this.hierarchy = new HashMap();
        this.hierarchy.put("ID", new Integer(0));
        this.hierarchy.put("AC", new Integer(1000));
        this.hierarchy.put("DT", new Integer(2000));
        this.hierarchy.put("DE", new Integer(3000));
        this.hierarchy.put("GN", new Integer(4000));
        this.hierarchy.put("OS", new Integer(5000));
        this.hierarchy.put("OG", new Integer(5500));
        this.hierarchy.put("OC", new Integer(6000));
        this.hierarchy.put("OX", new Integer(7000));
        this.hierarchy.put("RN", new Integer(8000));
        this.hierarchy.put("RC", new Integer(8200));
        this.hierarchy.put("RP", new Integer(8300));
        this.hierarchy.put("RX", new Integer(8400));
        this.hierarchy.put("RA", new Integer(8500));
        this.hierarchy.put("RG", new Integer(8600));
        this.hierarchy.put("RT", new Integer(8700));
        this.hierarchy.put("RL", new Integer(8800));
        this.hierarchy.put("CC", new Integer(8500));
        this.hierarchy.put("DR", new Integer(9000));
        this.hierarchy.put("PE", new Integer(9500));
        this.hierarchy.put("FT", new Integer(10000));
        this.hierarchy.put("KW", new Integer(11000));
        this.hierarchy.put("**EV", new Integer(11500));
        this.hierarchy.put("SQ", new Integer(12000));
        this.hierarchy.put("  ", new Integer(13000));
        this.hierarchy.put("//", new Integer(14000));
    }

    private void generateDefaultEntryText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStandardIDLine());
        sb.append('\n');
        sb.append(this.getStandardACLine());
        sb.append('\n');
        sb.append(this.getStandardDTCreatedLine());
        sb.append('\n');
        sb.append(this.getStandardDTSequenceUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDTAnnotationUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDELine());
        sb.append('\n');
        sb.append(this.getStandardOSLine());
        sb.append('\n');
        sb.append(this.getStandardOCLine());
        sb.append('\n');
        sb.append(this.getStandardOXLine());
        sb.append('\n');
        sb.append(this.getStandardLiteratureReference());
        sb.append('\n');
        sb.append(this.getStandardPELine());
        sb.append('\n');
        sb.append(this.getStandardSQLine());
        sb.append('\n');
        sb.append(this.getStandardSQDataLine());
        sb.append('\n');
        sb.append(this.getStandardEOF());
        sb.append('\n');
        this.text = sb.toString();
    }

    public String getText() {
        return this.text;
    }

    public String getStandardIDLine() {
        return "ID   Q23456_CAEEL            Unreviewed;      1208 AA.";
    }

    public String getStandardACLine() {
        return "AC   Q23456;";
    }

    public String getStandardPELine() {
        return "PE   4: Predicted;";
    }

    public void setPESequenceUpdateLine(String peLine) {
        this.setLine(peLine, "PE   ", 1);
    }

    public String getStandardDTCreatedLine() {
        return "DT   01-FEB-1999, integrated into UniProtKB/TrEMBL.";
    }

    public String getStandardDTSequenceUpdateLine() {
        return "DT   15-OCT-2000, sequence version 2.";
    }

    public String getStandardDTAnnotationUpdateLine() {
        return "DT   15-DEC-2004, entry version 5.";
    }

    public String getStandardDELine() {
        return "DE   SubName: Full=Protein Name;";
    }

    public String getStandardOSLine() {
        return "OS   Homo sapiens (Human).";
    }

    public String getStandardOCLine() {
        return "OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Homo.";
    }

    public String getStandardOXLine() {
        return "OX   NCBI_TaxID=9606;";
    }

    public String getStandardSQLine() {
        return "SQ   SEQUENCE   589 AA;  65683 MW;  19F7D8DA999E528F CRC64;";
    }

    public String getStandardSQDataLine() {
        return "     MLHLHHSCLC FRSWLPAMLA VLLSLAPSAS SDISASRPNI LLLMA";
    }

    public String getStandardEOF() {
        return "//";
    }

    public String getStandardLiteratureReference() {
        return "RN   [1]\nRP   CHARACTERIZATION.\nRC   TISSUE=Brain;\nRX   PubMed=9497243;\nRA   Daniele A., Parenti G., D'Addio M., Andria G., Ballabio A., Meroni G.;\nRT   \"Biochemical characterization of arylsulfatase E.\";\nRL   Am. J. Hum. Genet. 62:562-577(1998).";
    }

    public void resetIDLine() {
        this.setIDLine(this.getStandardIDLine());
    }

    public void setIDLine(String idLine) {
        this.setLine(idLine, "ID   ", 1);
    }

    public void setACLine(String acLine) {
        this.setLine(acLine, "AC   ", 1);
    }

    public void setDTCreatedLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 1);
    }

    public void setDTSequenceUpdateLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 2);
    }

    public void setDTAnnotationUpdateLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 3);
    }

    public void setDELine(String deLine) {
        if (!this.setLine(deLine, "DE   ", 1)) {
            this.insertLine(deLine);
        }
    }

    public void setGNLine(String gnLine) {
        if (!this.setLine(gnLine, "GN   ", 1)) {
            this.insertLine(gnLine);
        }
    }

    public void setOSLine(String osLine) {
        if (!this.setLine(osLine, "OS   ", 1)) {
            this.insertLine(osLine);
        }
    }

    public void insertOSLine(String osLine) {
        this.insertLine(osLine);
    }

    public void setOGLine(String ogLine) {
        this.insertLine(ogLine);
    }

    public void setOXLine(String gnLine) {
        if (!this.setLine(gnLine, "OX   ", 1)) {
            this.insertLine(gnLine);
        }
    }

    public void setRNLine(String rnLine) {
        this.setLine(rnLine, "RN   ", 1);
    }

    public void setRCLine(String rcLine) {
        this.setLine(rcLine, "RC   ", 1);
    }

    public void setKWLine(String kwLine) {
        if (!this.setLine(kwLine, "KW   ", 1)) {
            this.insertLine(kwLine);
        }
    }

    public void addSSEVLine(String ssevLine) {
        if (!this.setLine(ssevLine, "**EV ", 1)) {
            this.insertLine(ssevLine);
        }
    }

    public void setSQLine(String sqLine) {
        if (!this.setLine(sqLine, "SQ   ", 1)) {
            this.insertLine(sqLine);
        }
    }

    public void setSQDataLine(String sqDataLine) {
        if (!this.setLine(sqDataLine, "     ", 1)) {
            this.insertLine(sqDataLine);
        }
    }

    public void setOCLine(String ocLine) {
        if (!this.setLine(ocLine, "OC   ", 1)) {
            this.insertLine(ocLine);
        }
    }

    public void setRPLine(String ocLine) {
        if (!this.setLine(ocLine, "RP   ", 1)) {
            this.insertLine(ocLine);
        }
    }

    public void insertCCLine(String ccLine) {
        this.insertLine(ccLine);
    }

    public void insertDRLine(String drLine) {
        this.insertLine(drLine);
    }

    private void insertLine(String newLine) {
        boolean wasAppended = false;
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        StringBuilder newText = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!this.isEarlyer(line, newLine) && !wasAppended) {
                newText.append(newLine);
                newText.append("\n");
                wasAppended = true;
            }
            newText.append(line);
            newText.append("\n");
        }
        this.text = newText.toString();
    }

    private boolean isEarlyer(String line1, String line2) {
        Integer i2;
        Integer i1 = this.hierarchy.get(line1.substring(0, 2));
        if (i1 == null) {
            i1 = this.hierarchy.get(line1.substring(0, 4));
        }
        if ((i2 = this.hierarchy.get(line2.substring(0, 2))) == null) {
            i2 = this.hierarchy.get(line2.substring(0, 4));
        }
        return i1 <= i2;
    }

    private boolean setLine(String newLine, String token, int index) {
        boolean wasReplaced = false;
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        StringBuilder newText = new StringBuilder();
        int counter = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith(token)) {
                if (!wasReplaced && ++counter == index) {
                    newText.append(newLine);
                    newText.append("\n");
                    wasReplaced = true;
                    continue;
                }
                newText.append(line);
                newText.append("\n");
                continue;
            }
            newText.append(line);
            newText.append("\n");
        }
        this.text = newText.toString();
        return wasReplaced;
    }
}

