/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.test;

import java.util.HashMap;
import java.util.StringTokenizer;

public class SwissProtEntryText {
    private String text;
    private HashMap<String, Integer> hierarchy;

    public SwissProtEntryText() {
        this.generateDefaultEntryText();
        this.initLineHierarchy();
    }

    private void initLineHierarchy() {
        this.hierarchy = new HashMap();
        this.hierarchy.put("ID", new Integer(0));
        this.hierarchy.put("AC", new Integer(1000));
        this.hierarchy.put("DT", new Integer(2000));
        this.hierarchy.put("DE", new Integer(3000));
        this.hierarchy.put("GN", new Integer(4000));
        this.hierarchy.put("OS", new Integer(5000));
        this.hierarchy.put("OG", new Integer(5500));
        this.hierarchy.put("OC", new Integer(6000));
        this.hierarchy.put("OX", new Integer(7000));
        this.hierarchy.put("OH", new Integer(7500));
        this.hierarchy.put("RN", new Integer(8000));
        this.hierarchy.put("RA", new Integer(8001));
        this.hierarchy.put("RL", new Integer(8002));
        this.hierarchy.put("RT", new Integer(8003));
        this.hierarchy.put("RP", new Integer(8004));
        this.hierarchy.put("RC", new Integer(8005));
        this.hierarchy.put("RX", new Integer(8006));
        this.hierarchy.put("CC", new Integer(8500));
        this.hierarchy.put("DR", new Integer(9000));
        this.hierarchy.put("PE", new Integer(10000));
        this.hierarchy.put("KW", new Integer(11000));
        this.hierarchy.put("FT", new Integer(12000));
        this.hierarchy.put("**EV", new Integer(11500));
        this.hierarchy.put("**", new Integer(11500));
        this.hierarchy.put("SQ", new Integer(13000));
        this.hierarchy.put("  ", new Integer(14000));
        this.hierarchy.put("//", new Integer(15000));
    }

    private void generateDefaultEntryText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStandardIDLine());
        sb.append('\n');
        sb.append(this.getStandardACLine());
        sb.append('\n');
        sb.append(this.getStandardDTCreatedLine());
        sb.append('\n');
        sb.append(this.getStandardDTSequenceUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDTAnnotationUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDELine());
        sb.append('\n');
        sb.append(this.getStandardOSLine());
        sb.append('\n');
        sb.append(this.getStandardOCLine());
        sb.append('\n');
        sb.append(this.getStandardOXLine());
        sb.append('\n');
        sb.append(this.getStandardLiteratureReference());
        sb.append('\n');
        sb.append(this.getStandardPELine());
        sb.append('\n');
        sb.append(this.getStandardSQLine());
        sb.append('\n');
        sb.append(this.getStandardSQDataLine());
        sb.append('\n');
        sb.append(this.getStandardEOF());
        sb.append('\n');
        this.text = sb.toString();
    }

    public String getText() {
        return this.text;
    }

    public String generateTextWithReference(String reference) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStandardIDLine());
        sb.append('\n');
        sb.append(this.getStandardACLine());
        sb.append('\n');
        sb.append(this.getStandardDTCreatedLine());
        sb.append('\n');
        sb.append(this.getStandardDTSequenceUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDTAnnotationUpdateLine());
        sb.append('\n');
        sb.append(this.getStandardDELine());
        sb.append('\n');
        sb.append(this.getStandardOSLine());
        sb.append('\n');
        sb.append(this.getStandardOCLine());
        sb.append('\n');
        sb.append(this.getStandardOXLine());
        sb.append('\n');
        sb.append(reference);
        sb.append('\n');
        sb.append(this.getStandardPELine());
        sb.append('\n');
        sb.append(this.getStandardSQLine());
        sb.append('\n');
        sb.append(this.getStandardSQDataLine());
        sb.append('\n');
        sb.append(this.getStandardEOF());
        sb.append('\n');
        this.text = sb.toString();
        return this.text;
    }

    public String getStandardIDLine() {
        return "ID   ARSE_HUMAN              Reviewed;         589 AA.";
    }

    public String getStandardACLine() {
        return "AC   P51690;";
    }

    public String getStandardDTCreatedLine() {
        return "DT   01-JAN-1998, integrated into UniProtKB/Swiss-Prot.";
    }

    public String getStandardDTSequenceUpdateLine() {
        return "DT   15-OCT-2001, sequence version 3.";
    }

    public String getStandardDTAnnotationUpdateLine() {
        return "DT   01-APR-2004, entry version 14.";
    }

    public String getStandardDELine() {
        return "DE   RecName: Full=Protein name;";
    }

    public String getStandardOSLine() {
        return "OS   Homo sapiens (Human).";
    }

    public String getStandardOCLine() {
        return "OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Homo.";
    }

    public String getStandardOXLine() {
        return "OX   NCBI_TaxID=9606;";
    }

    public String getStandardSQLine() {
        return "SQ   SEQUENCE   589 AA;  65683 MW;  19F7D8DA999E528F CRC64;";
    }

    public String getStandardPELine() {
        return "PE   1: Evidence at protein level;";
    }

    public String getStandardSQDataLine() {
        return "     MLHLHHSCLC FRSWLPAMLA VLLSLAPSAS SDISASRPNI LLLMA";
    }

    public String getStandardEOF() {
        return "//";
    }

    public void addSSEVLine(String ssevLine) {
        if (!this.setLine(ssevLine, "**EV ", 1)) {
            this.insertLine(ssevLine);
        }
    }

    public String getStandardLiteratureReference() {
        return "RN   [1]\nRP   CHARACTERIZATION.\nRX   PubMed=9497243;\nRA   Daniele A., Parenti G., D'Addio M., Andria G., Ballabio A., Meroni G.;\nRT   \"Biochemical characterization of arylsulfatase E.\";\nRL   Am. J. Hum. Genet. 62:562-577(1998).";
    }

    public void resetIDLine() {
        this.setIDLine(this.getStandardIDLine());
    }

    public void setIDLine(String idLine) {
        this.setLine(idLine, "ID   ", 1);
    }

    public void setACLine(String acLine) {
        this.setLine(acLine, "AC   ", 1);
    }

    public void setDTCreatedLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 1);
    }

    public void setDTSequenceUpdateLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 2);
    }

    public void setPESequenceUpdateLine(String peLine) {
        this.setLine(peLine, "PE   ", 1);
    }

    public void setDTAnnotationUpdateLine(String dtLine) {
        this.setLine(dtLine, "DT   ", 3);
    }

    public void setDELine(String deLine) {
        if (!this.setLine(deLine, "DE   ", 1)) {
            this.insertLine(deLine);
        }
    }

    public void setGNLine(String gnLine) {
        if (!this.setLine(gnLine, "GN   ", 1)) {
            this.insertLine(gnLine);
        }
    }

    public void setOHLine(String gnLine) {
        if (!this.setLine(gnLine, "OH   ", 1)) {
            this.insertLine(gnLine);
        }
    }

    public void setOGLine(String ogLine) {
        this.insertLine(ogLine);
    }

    public void setOXLine(String oxLine) {
        this.setLine(oxLine, "OX   ", 1);
    }

    public void setPELine(String oxLine) {
        this.setLine(oxLine, "PE   ", 1);
    }

    public void setOSLine(String osLine) {
        if (!this.setLine(osLine, "OS   ", 1)) {
            this.insertLine(osLine);
        }
    }

    public void setRPLine(String rpLine) {
        if (!this.setLine(rpLine, "RP   ", 1)) {
            this.insertLine(rpLine);
        }
    }

    public void setRCLine(String rpLine) {
        if (!this.setLine(rpLine, "RC   ", 1)) {
            this.insertLine(rpLine);
        }
    }

    public void setRLLine(String rlLine) {
        if (!this.setLine(rlLine, "RL   ", 1)) {
            this.insertLine(rlLine);
        }
    }

    public void insertOHLine(String ohLine) {
        this.insertLine(ohLine);
    }

    public void insertKWLine(String kwLine) {
        this.insertLine(kwLine);
    }

    public void setSQLine(String sqLine) {
        if (!this.setLine(sqLine, "SQ   ", 1)) {
            this.insertLine(sqLine);
        }
    }

    public void setSQDataLine(String sqDataLine) {
        if (!this.setLine(sqDataLine, "     ", 1)) {
            this.insertLine(sqDataLine);
        }
    }

    public void insertOSLine(String osLine) {
        this.insertLine(osLine);
    }

    public void setOCLine(String ocLine) {
        if (!this.setLine(ocLine, "OC   ", 1)) {
            this.insertLine(ocLine);
        }
    }

    public void insertCCLine(String ccLine) {
        this.insertLine(ccLine);
    }

    public void insertDRLine(String drLine) {
        this.insertLine(drLine);
    }

    public void insertFTLine(String ftLine) {
        this.insertLine(ftLine);
    }

    private void insertLine(String newLine) {
        boolean wasAppended = false;
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        StringBuilder newText = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!this.isEarlyer(line, newLine) && !wasAppended) {
                newText.append(newLine);
                newText.append("\n");
                wasAppended = true;
            }
            newText.append(line);
            newText.append("\n");
        }
        this.text = newText.toString();
    }

    private boolean isEarlyer(String line1, String line2) {
        int i2;
        int i1 = this.hierarchy.get(line1.substring(0, 2));
        return i1 <= (i2 = this.hierarchy.get(line2.substring(0, 2)).intValue());
    }

    private boolean setLine(String newLine, String token, int index) {
        boolean wasReplaced = false;
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        StringBuilder newText = new StringBuilder();
        int counter = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith(token)) {
                if (!wasReplaced && ++counter == index) {
                    newText.append(newLine);
                    newText.append("\n");
                    wasReplaced = true;
                    continue;
                }
                newText.append(line);
                newText.append("\n");
                continue;
            }
            newText.append(line);
            newText.append("\n");
        }
        this.text = newText.toString();
        return wasReplaced;
    }
}

