/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.util.runtime.ReflectiveInvocationException;

public class ReflectiveInvocationHelper {
    private Object target;

    private ReflectiveInvocationHelper(Object target) {
        if (null == target) {
            throw new ReflectiveInvocationException("target cannot be null");
        }
        this.target = target;
    }

    public static ReflectiveInvocationHelper forClass(Class<?> cls) {
        return ReflectiveInvocationHelper.forObject(cls);
    }

    public static ReflectiveInvocationHelper forObject(Object obj) {
        return new ReflectiveInvocationHelper(obj);
    }

    public static ReflectiveInvocationHelper forClassName(String clsName) {
        Class<?> cls;
        try {
            cls = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectiveInvocationException(String.format("Couldn't load class by name: %s. Error: %s", clsName, e.getMessage()), e);
        }
        return new ReflectiveInvocationHelper(cls);
    }

    public ReflectiveInvocationHelper staticField(String fieldName) {
        Class<?> trg = this.assertTargetIsAClassObject(this.getTargetForce());
        Field declaredField = null;
        try {
            declaredField = trg.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReflectiveInvocationException(String.format("failed to find field '%s' in the class '%s'. Error: %s", fieldName, trg, e.getMessage()), e);
        }
        try {
            this.target = declaredField.get(this.target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectiveInvocationException(String.format("failed to obtain '%s' field value of the class '%s'. Error: %s", fieldName, trg, e.getMessage()), e);
        }
        return this;
    }

    private Class<?> assertTargetIsAClassObject(Object trg) {
        Class<?> trgCls = trg.getClass();
        if (!Class.class.isAssignableFrom(trgCls)) {
            throw new ReflectiveInvocationException("cannot get static field when the target class is not a subclass of %s: %s", Class.class, trgCls);
        }
        return (Class)trg;
    }

    public ReflectiveInvocationHelper invokeMethod(String methodName, Object ... params) {
        Object trg = this.getTargetForce();
        return this.invokeMethodInternal(trg, trg.getClass(), methodName, params);
    }

    public ReflectiveInvocationHelper invokeStaticMethod(String methodName, Object ... params) {
        Class<?> trg = this.assertTargetIsAClassObject(this.getTargetForce());
        return this.invokeMethodInternal(null, trg, methodName, params);
    }

    private ReflectiveInvocationHelper invokeMethodInternal(Object trg, Class<?> trgClass, String methodName, Object ... params) {
        LinkedList paramTypes = new LinkedList();
        for (Object p : params) {
            if (null == p) {
                throw new ReflectiveInvocationException("got null parameter when attempting to invoke '%s' on an instance %s", methodName, trg);
            }
            paramTypes.add(p.getClass());
        }
        Method method = null;
        try {
            method = trgClass.getMethod(methodName, paramTypes.toArray(new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ReflectiveInvocationException("failed to find method '%s' on an instance '%s' using parameter types: '%s'", methodName, trg, paramTypes.stream().map(val -> val.toString()).collect(Collectors.joining()));
        }
        try {
            this.target = method.invoke(trg, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ReflectiveInvocationException(String.format("failed to invoke method '%s' on an instance '%s' using parameters: '%s'. Error: %s", methodName, trg, paramTypes.stream().map(val -> val.toString()).collect(Collectors.joining()), e.getMessage()), e);
        }
        return this;
    }

    private Object getTargetForce() {
        if (null == this.target) {
            throw new ReflectiveInvocationException("the target object is null");
        }
        return this.target;
    }

    public Object getCurrentResult() {
        return this.target;
    }

    public <T> T getCurrentResult(Class<T> forceClass) {
        Object resultRaw = this.getCurrentResult();
        if (null == resultRaw) {
            return null;
        }
        if (!forceClass.isAssignableFrom(resultRaw.getClass())) {
            throw new ReflectiveInvocationException("cannot cast %s to expected %d class", resultRaw.getClass(), forceClass);
        }
        Object resultT = resultRaw;
        return (T)resultT;
    }
}

