/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.net;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.net.HttpService;

public class HttpServiceImpl
implements HttpService {
    private static final String HTTP_STANDARD_RFC_2822_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServiceImpl.class);
    private CloseableHttpClient httpClient = this.initWithSSL();
    private RequestConfig config = null;

    private CloseableHttpClient initWithSSL() {
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            String host = System.getProperty("http.proxyHost");
            String port = System.getProperty("http.proxyPort");
            if (host != null && !host.isEmpty() && port != null && !port.isEmpty()) {
                LOGGER.info("detected proxy: {}, {}", (Object)host, (Object)port);
                HttpHost proxy = new HttpHost(host, Integer.valueOf(port).intValue());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            }
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void setRequestConfig(RequestConfig config) {
        this.config = config;
    }

    @Override
    public HttpResponse callPostWithParameters(String url, List<NameValuePair> params) throws IOException {
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("There are not parameters to append to the url");
        }
        HttpPost httpPost = (HttpPost)this.prepareCall(url, false);
        UrlEncodedFormEntity ent = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)ent);
        return this.httpClient.execute((HttpUriRequest)httpPost);
    }

    @Override
    public HttpResponse callPostWithJson(String url, String json) throws IOException {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("There are not parameters to post to the url");
        }
        HttpPost httpPost = (HttpPost)this.prepareCall(url, false);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(json));
        return this.httpClient.execute((HttpUriRequest)httpPost);
    }

    @Override
    public InputStream getInputStreamFromResponse(HttpResponse httpResponse) throws IOException {
        HttpEntity resEntity = httpResponse.getEntity();
        return resEntity.getContent();
    }

    @Override
    public HttpRequestBase prepareCall(String url, boolean isGet) {
        HttpGet request = isGet ? new HttpGet(url) : new HttpPost(url);
        request.setConfig(this.config);
        return request;
    }

    @Override
    public HttpResponse call(String url, boolean isGet) throws IOException {
        return this.httpClient.execute((HttpUriRequest)this.prepareCall(url, isGet));
    }

    @Override
    public Header[] getSpecificResponseHeader(HttpResponse httpResponse, String responseHeader) {
        return httpResponse.getHeaders(responseHeader);
    }

    @Override
    public Header[] getAllResponseHeaders(HttpResponse httpResponse) {
        return httpResponse.getAllHeaders();
    }

    @Override
    public Date getResponseLastModifiedHeader(HttpResponse httpResponse) throws ParseException {
        Header[] lastModifiedHeaders = this.getSpecificResponseHeader(httpResponse, "Last-Modified");
        if (lastModifiedHeaders == null || lastModifiedHeaders.length != 1) {
            return null;
        }
        String date = lastModifiedHeaders[0].getValue();
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_STANDARD_RFC_2822_DATE_FORMAT, Locale.UK);
        return sdf.parse(date);
    }

    @Override
    public boolean download(HttpResponse httpResponse, String newFilePath) throws IOException {
        boolean isDownloaded = false;
        HttpEntity resEntity = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(newFilePath);){
            resEntity = httpResponse.getEntity();
            if (resEntity != null) {
                resEntity.writeTo((OutputStream)fileOutputStream);
                isDownloaded = true;
                LOGGER.debug("Downloaded {} ", (Object)newFilePath);
            }
        }
        return isDownloaded;
    }

    @Override
    public void closeConnection() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

