/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class NoNullElementsCollection<E>
implements Collection<E>,
Serializable {
    protected Collection<E> collection;

    public NoNullElementsCollection() {
        this.collection = new ArrayList();
    }

    public NoNullElementsCollection(Collection<E> originalCollection) {
        if (originalCollection == null) {
            throw new IllegalArgumentException();
        }
        for (E e : originalCollection) {
            if (e != null) continue;
            throw new IllegalArgumentException();
        }
        try {
            this.collection = (Collection)originalCollection.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Can not guarantee that given list contains no null elements.", e);
        }
        this.collection.addAll(originalCollection);
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return this.collection.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        for (E e : c) {
            if (e != null) continue;
            throw new IllegalArgumentException();
        }
        return this.collection.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.collection.iterator();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    public String toString() {
        return this.collection.toString();
    }
}

