/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;
import uk.ac.ebi.uniprot.parser.impl.cc.CcLineUtils;

public class TextOnlyCommentTranslator
implements CommentTranslator<TextOnlyComment> {
    private static final String EVIDENCE_PREFIX = "{ECO";
    private static final String EVIDENCE_POSTFIX = "}";
    private static final String COLON = ":";
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();

    @Override
    public TextOnlyComment translate(String annotation) {
        int index = annotation.indexOf(COLON);
        String type = annotation.substring(0, index);
        annotation = annotation.substring(index + 1).trim();
        CommentType commentType = CommentType.typeOf(type);
        TextOnlyComment comment = (TextOnlyComment)FACTORY.buildComment(commentType);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, TextOnlyComment comment) {
        int indexPre = 0;
        int indexPost = 0;
        ArrayList<CommentText> texts = new ArrayList<CommentText>();
        boolean first = true;
        while ((indexPre = annotation.indexOf(EVIDENCE_PREFIX)) != -1 && (indexPost = annotation.indexOf(EVIDENCE_POSTFIX, indexPre)) != -1) {
            String value = annotation.substring(0, indexPost + 1);
            CommentText cText = this.createCommentText(value);
            if (first) {
                first = false;
                List<String> result = CcLineUtils.parseFreeText(cText.getValue());
                String newValue = result.get(1);
                String molecule = result.get(0);
                comment.setMolecule(molecule);
                cText.setValue(newValue);
            }
            texts.add(cText);
            annotation = annotation.substring(indexPost + 2).trim();
            if (indexPost != -1 && indexPre != -1) continue;
        }
        if (!annotation.isEmpty()) {
            CommentText cText = this.createCommentText(annotation);
            if (first) {
                first = false;
                List<String> result = CcLineUtils.parseFreeText(cText.getValue());
                String newValue = result.get(1);
                String molecule = result.get(0);
                comment.setMolecule(molecule);
                cText.setValue(newValue);
            }
            texts.add(cText);
        }
        comment.setTexts(texts);
    }

    private CommentText createCommentText(String value) {
        value = CommentTranslatorHelper.stripTrailing(value, ".");
        ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
        value = CommentTranslatorHelper.stripEvidenceIds(value, evidences);
        value = CommentTranslatorHelper.stripTrailing(value, ".");
        CommentText text = FACTORY.buildCommentText();
        value = CommentTranslatorHelper.setCommentStatus(value, text);
        text.setValue(value);
        text.setEvidenceIds(evidences);
        return text;
    }
}

