/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class AlternativeProductsCommentTranslator
implements CommentTranslator<AlternativeProductsComment> {
    private static final String EVENT = "Event=";
    private static final String NAME_ISOFORM = "Named isoforms=";
    private static final String COMMENT = "Comment=";
    private static final String NAME = "Name=";
    private static final String SYNONYMS = "Synonyms=";
    private static final String NOTE = "Note=";
    private static final String ISOID = "IsoId=";
    private static final String SEQUENCE = "Sequence=";
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.ALTERNATIVE_PRODUCTS;

    @Override
    public AlternativeProductsComment translate(String annotation) {
        AlternativeProductsComment comment = (AlternativeProductsComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, AlternativeProductsComment comment) {
        if ((annotation = CommentTranslatorHelper.stripTrailing(annotation, ".")) == null || annotation.length() <= 0) {
            throw new IllegalArgumentException();
        }
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        String[] tokens = annotation.split(";");
        AlternativeProductsIsoform currentIsoform = null;
        for (int i = 0; i < tokens.length; ++i) {
            String label;
            String val;
            String token = tokens[i].trim();
            if (token.startsWith(EVENT)) {
                String[] eventTokens;
                List<AlternativeProductsEvent> events = comment.getEvents();
                val = token.substring(EVENT.length());
                for (String eventToken : eventTokens = val.split(",")) {
                    events.add(FACTORY.buildAlternativeProductsEvent(eventToken.trim()));
                }
                comment.setEvents(events);
                continue;
            }
            if (token.startsWith(NAME_ISOFORM)) continue;
            if (token.startsWith(COMMENT)) {
                String val2 = token.substring(COMMENT.length());
                ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
                evValues.add(CommentTranslatorHelper.parseEvidencedValue(val2, false));
                int j = i + 1;
                boolean test = true;
                do {
                    if (!this.isPartOfComment(val2 = tokens[j].trim())) {
                        i = j - 1;
                        test = false;
                        break;
                    }
                    evValues.add(CommentTranslatorHelper.parseEvidencedValue(val2, false));
                } while (test && ++j < tokens.length);
                AlternativeProductsCommentComment apComment = FACTORY.buildAlternativeProductsCommentComment();
                apComment.setTexts(evValues);
                comment.setComment(apComment);
                continue;
            }
            if (token.startsWith(NAME)) {
                label = token.substring(NAME.length());
                currentIsoform = DefaultUniProtFactory.getCommentFactory().buildAlternativeProductsIsoform();
                comment.getIsoforms().add(currentIsoform);
                IsoformName name = DefaultUniProtFactory.getCommentFactory().buildIsoformName();
                name.setValue(CommentTranslatorHelper.stripEvidenceIds(label, name.getEvidenceIds()));
                currentIsoform.setName(name);
                continue;
            }
            if (token.startsWith(SYNONYMS)) {
                label = token.substring(SYNONYMS.length());
                currentIsoform.setSynonyms(this.buildSynonyms(label));
                continue;
            }
            if (token.startsWith(ISOID)) {
                String[] isoIds;
                label = token.substring(ISOID.length());
                for (String id : isoIds = label.split(",")) {
                    IsoformId isoid = DefaultUniProtFactory.getCommentFactory().buildIsoformId(id.trim());
                    currentIsoform.getIds().add(isoid);
                }
                continue;
            }
            if (token.startsWith(SEQUENCE)) {
                label = token.substring(SEQUENCE.length()).trim();
                if (label.equalsIgnoreCase(IsoformSequenceStatus.DISPLAYED.getValue())) {
                    currentIsoform.setIsoformSequenceStatus(IsoformSequenceStatus.DISPLAYED);
                    continue;
                }
                if (label.equalsIgnoreCase(IsoformSequenceStatus.NOT_DESCRIBED.getValue())) {
                    currentIsoform.setIsoformSequenceStatus(IsoformSequenceStatus.NOT_DESCRIBED);
                    continue;
                }
                if (label.equalsIgnoreCase(IsoformSequenceStatus.EXTERNAL.getValue())) {
                    currentIsoform.setIsoformSequenceStatus(IsoformSequenceStatus.EXTERNAL);
                    continue;
                }
                StringTokenizer seqIds = new StringTokenizer(label, ",");
                while (seqIds.hasMoreTokens()) {
                    String seqId = seqIds.nextToken().trim();
                    currentIsoform.getSequenceIds().add(DefaultUniProtFactory.getCommentFactory().buildIsoformSequenceId(seqId));
                }
                continue;
            }
            if (!token.startsWith(NOTE)) continue;
            IsoformNote note = DefaultUniProtFactory.getCommentFactory().buildIsoformNote();
            val = token.substring(NOTE.length());
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            evValues.add(CommentTranslatorHelper.parseEvidencedValue(val, false));
            boolean test = true;
            for (int j = i + 1; test && j < tokens.length; ++j) {
                val = tokens[j].trim();
                if (!this.isPartOfComment(val)) {
                    i = j - 1;
                    test = false;
                    break;
                }
                evValues.add(CommentTranslatorHelper.parseEvidencedValue(val, false));
            }
            note.setTexts(evValues);
            currentIsoform.setNote(note);
        }
    }

    private List<IsoformSynonym> buildSynonyms(String value) {
        ArrayList<IsoformSynonym> synonyms = new ArrayList<IsoformSynonym>();
        int index = value.indexOf(44);
        int evInd1 = value.indexOf(123);
        int evInd2 = value.indexOf(125);
        if (evInd1 == -1 || evInd2 == -1) {
            String[] synsTokens;
            for (String syn : synsTokens = value.split(",")) {
                syn = syn.trim();
                IsoformSynonym isosyn = DefaultUniProtFactory.getCommentFactory().buildIsoformSynonym();
                isosyn.setValue(CommentTranslatorHelper.stripEvidenceIds(syn, isosyn.getEvidenceIds()));
                synonyms.add(isosyn);
            }
            return synonyms;
        }
        String temp = value;
        boolean isTrue = true;
        if (evInd1 != -1 && evInd2 != -1 && index > evInd1 && index < evInd2) {
            index = temp.indexOf(44, evInd2);
        }
        if (index == -1) {
            isTrue = false;
        }
        while (isTrue) {
            String syn = temp.substring(0, index);
            temp = temp.substring(index + 1).trim();
            IsoformSynonym isosyn = DefaultUniProtFactory.getCommentFactory().buildIsoformSynonym();
            isosyn.setValue(CommentTranslatorHelper.stripEvidenceIds(syn, isosyn.getEvidenceIds()));
            synonyms.add(isosyn);
            evInd1 = temp.indexOf(123);
            evInd2 = temp.indexOf(125);
            index = temp.indexOf(44);
            if (evInd1 != -1 && evInd2 != -1) {
                if (index == -1) break;
                if (index > evInd1 && index < evInd2) {
                    index = temp.indexOf(44, evInd2);
                }
            }
            if (index != -1) continue;
            break;
        }
        if (!temp.isEmpty()) {
            IsoformSynonym isosyn = DefaultUniProtFactory.getCommentFactory().buildIsoformSynonym();
            isosyn.setValue(CommentTranslatorHelper.stripEvidenceIds(temp, isosyn.getEvidenceIds()));
            synonyms.add(isosyn);
        }
        return synonyms;
    }

    private boolean isPartOfComment(String token) {
        return !token.startsWith(EVENT) && !token.startsWith(NAME_ISOFORM) && !token.startsWith(COMMENT) && !token.startsWith(NAME) && !token.startsWith(SYNONYMS) && !token.startsWith(NOTE) && !token.startsWith(ISOID) && !token.startsWith(SEQUENCE);
    }
}

